import Vue from 'vue'
import Vuex from 'vuex'
import api from '../api/api.js'
//获取scss中的样式
import globalScssInfo from '../uni.scss'
import saveLnLocal from '../plugins/saveInLocal.js'
let defaultinfo = {
	primaryColor: `--primaryColor:${globalScssInfo['--primaryColor']};--primaryBtnColor:${globalScssInfo['--primaryBtnColor']}`,
}
Vue.use(Vuex)
const store = new Vuex.Store({
	state: {
		globelColor: defaultinfo, //全局风格
		PageQuery: 'home',
		store: {},
		cart: [],
		orderType: 'takein',
		address: 'takein',
		addresses: [],
		paymentH5Popup: '',
		member: {},
		order: {},
		integralDetail: {},
		userinfo: {},
		giftcardInfo: {},
		quotaInfo: {},
		orderCouponInfo: {},
		phoneNumber: '',
		IndexPopup: false,
		remark: '',
		router: '',
		tips: false,
		groupaddresses: {},
		parentId: '',
		isIphoneX: false,
		FeignWxMessageInfo: {},
		historydata: [],
		giftCardDetailsInfo: {},
		sessionKeyInfo: {},
		salesManId: '',
		userImgFile:{}
	},
	getters: {
		memberId: (state) => (state.member.member || {}).id, //用户id
		inviteCode: (state) => (state.member.member || {}).id, //分享码id
		isLogin: (state) => Object.keys(state.member).length > 0, //是否登录
	},
	mutations: {
		SET_USER_IMG_FilE(state,userImg){
			state.userImgFile = userImgFile;
		},
		SET_SALES_MANNID(state, salesManId) {
			state.salesManId = salesManId;
		},
		SET_PAYMENT_H5_POPUP(state, paymentH5Popup) {
			state.paymentH5Popup = paymentH5Popup
		},
		SET_SESSION_KEY(state, sessionKeyInfo) {
			state.sessionKeyInfo = sessionKeyInfo
		},
		SET_GiftCardDetailsInfo(state, giftCardDetailsInfo) {
			state.giftCardDetailsInfo = giftCardDetailsInfo
		},
		SET_Historydata(state, historydata) {
			state.historydata = historydata
		},
		SET_FeignWxMessageInfo(state, FeignWxMessageInfo) {
			state.FeignWxMessageInfo = FeignWxMessageInfo
		},
		SET_GlobelColor(state, globelColor) {
			state.globelColor = globelColor
		},
		SET_PAGEQUERY(state, PageQuery) {
			state.PageQuery = PageQuery
		},
		SET_IS_IphoneX(state, isIphoneX) {
			state.isIphoneX = isIphoneX
		},
		SET_USER_INFO(state, userinfo) {
			state.userinfo = userinfo
		},
		SET_ROUTER(state, router) {
			state.router = router
		},
		SET_REMARK(state, remark) {
			state.remark = remark
		},
		SET_PHONE_NUMBER(state, phoneNumber) {
			state.phoneNumber = phoneNumber
		},
		SET_INDEX_POPUP(state, IndexPopup) {
			state.IndexPopup = IndexPopup
		},
		SET_QUOOA_INFO(state, quotaInfo) {
			state.quotaInfo = quotaInfo
		},
		SET_GIFTCARD_INFO(state, giftcardInfo) {
			state.giftcardInfo = giftcardInfo
		},
		// 设置订单券
		SET_ORDER_COUPON_INFO(state, orderCouponInfo) {
			state.orderCouponInfo = orderCouponInfo
		},
		SET_INTEGAl_DETAIL(state, integralDetail) {
			state.integralDetail = integralDetail
		},
		// 点单
		SET_ORDER_TYPE(state, type) {
			state.orderType = type
		},
		// 拼单
		SET_SPELLGROUP_TYPE(state, spellGroupType) {
			state.spellGroupType = spellGroupType
		},
		SET_MEMBER(state, member) {
			state.member = member
		},
		SET_ADDRESS(state, address) {
			state.address = address
		},
		SET_ADDRESSES(state, addresses) {
			state.addresses = addresses
		},
		SET_STORE(state, store) {
			state.store = store
		},
		SET_CART(state, cart) {
			state.cart = cart
		},
		REMOVE_CART(state) {
			state.cart = []
		},
		SET_ORDER(state, order) {
			state.order = order
		},
		SET_TIPS(state, tips) {
			state.tips = tips
		},
		SET_GROUP_ADDRESS(state, groupaddresses) {
			state.groupaddresses = groupaddresses
		},
		SET_PARENTID(state, parentId) {
			state.parentId = parentId
		},

	},
	actions: {
		goMenu({
			commit
		}) {
			uni.navigateTo({
				url: '/pages/globalPage/index',
			})
			commit('SET_PAGEQUERY', 'category')
		},
		async getUserSomeCountInfo({
			commit
		}) {
			Vue.prototype.$http.getUserSomeCountInfo().then(({
				success,
				result
			}) => {
				if (success) {
					let info = JSON.parse(JSON.stringify(store.state.member))
					commit('SET_MEMBER', Object.assign({}, info, result))
				}
			})
		},
		resetVuex({
			commit
		}) {
			commit('SET_USER_INFO', {})
			commit('SET_PHONE_NUMBER', '')
			commit('SET_INDEX_POPUP', false)
			commit('SET_QUOOA_INFO', {})
			commit('SET_GIFTCARD_INFO', {})
			commit('SET_ORDER_COUPON_INFO', {})
			commit('SET_INTEGAl_DETAIL', {})
			commit('SET_ORDER_TYPE', 'takein')
			commit('SET_SPELLGROUP_TYPE', 'takein')
			commit('SET_MEMBER', {})
			commit('SET_ADDRESS', 'takein')
			commit('SET_ADDRESSES', [])
			commit('SET_STORE', {})
			commit('SET_GROUP_ADDRESS', {})
			commit('SET_CART', {})
			commit('REMOVE_CART', {})
			commit('SET_ORDER', {})
			commit('SET_REMARK', '')
			commit('SET_ROUTER', '')
			commit('SET_TIPS', false)
			commit('SET_PARENTID', '')
		},
		//清空选中的卡券信息
		resetPayCard({
			commit
		}) {
			commit('SET_QUOOA_INFO', {})
			commit('SET_GIFTCARD_INFO', {})
			commit('SET_ORDER_COUPON_INFO', {})
		},
		async getStore({
			commit
		}) {
			return new Promise((resolve) => {
				let that = this
				Vue.prototype.$http.getAppCodeShopInfo().then(({
					success,
					result
				}) => {
					if (success) {
						resolve(result)
					}
				})
			})
		},
		getSessionKeyByCode({
			commit
		}) {
			let self = this
			return new Promise((resolve, reject) => {
				uni.login({
					success: ({
						code
					}) => {
						let qyeryData = {
							appId: Vue.prototype.$http.appId,
							code,
						}
						Vue.prototype.$http
							.getSessionKeyByCode(qyeryData)
							.then(({
								success,
								result
							}) => {
								if (success) {
									commit('SET_SESSION_KEY', result)
								}
							})
					},
				})
			})
		},
		getPhoneNumber({commit}, e) {
			let self = this
			let info = store.state.userinfo
			const {encryptedData,signature,iv,errMsg} = e.detail
			info.encryptedData = encryptedData
			info.signature = signature
			info.iv = iv
			return new Promise((resolve, reject) => {
				uni.checkSession({
					success(checkSessionRes) {
						uni.getSetting({
							success(res) {
								if (errMsg == 'getPhoneNumber:ok') {
									if (res.authSetting['scope.userInfo']) {
										let {sessionKeyInfo} = store.state
										uni.login({success: ({code}) => {
											let info = Object.assign({},e.detail,sessionKeyInfo, {
													code: code,
													parentId: store.state.parentId,
													appId: Vue.prototype.$http.appId,
												})
												Vue.prototype.$http.getPhone(info).then(({success,result}) => {
													if (success) {
														resolve(result)
														commit('SET_PHONE_NUMBER',result.phoneNumber)
														commit('SET_USER_INFO',info)
													}
												})
											},
										})
									}
								}
							},
						})
					},
					fail(err) {
						// 已经失效，需要重新执行登录流程
						uni.login({
							success: ({code}) => {
								let queryData = {
									appId: Vue.prototype.$http.appId,
									code,
								}
								Vue.prototype.$http.getSessionKeyByCode(queryData).then(({success,result}) => {
									if (success) {
										let info = Object.assign({},
											result,
											e.detail,
											queryData, {
												parentId: store.state.parentId,
											}
										)
										Vue.prototype.$http.getPhone(info).then(({success,result}) => {
											if (success) {
												resolve(result)
												commit('SET_PHONE_NUMBER',result.phoneNumber)
												commit('SET_USER_INFO',info)
											}
										})
									}
								})
							},
						})
					},
				})
			})
		},
		// getUserProfile({commit}, e) {
		getWxLogin({commit}, e) {
			return new Promise((resolve, reject) => {
				uni.login({success: ({code}) => {
						let queryData = {appId: Vue.prototype.$http.appId,code: code}
						Vue.prototype.$http.getSessionKeyByCode(queryData).then(({success,result}) => {
							let info = Object.assign(e,result, {
								// appid: Vue.prototype.$http.appId,
								memberPhone: store.state.phoneNumber,
								parentId: store.state.parentId,
							})
							Vue.prototype.$http.appLogin(info).then(({success,result}) => {
								if (success) {
									resolve(result)
									let app =getApp()
									app.globalData.token = result.token
									commit('SET_MEMBER',result)
									commit('SET_USER_INFO',info)
								}
							})
						})
					},
				})
			})
		},

		getUserInfo({
			commit
		}, e) {
			let data = {
				id: store.state.member.member.id,
			}
			Vue.prototype.$http.getUserInfo(data).then(({
				success,
				result
			}) => {
				if (success) {
					if (result) {
						let info = JSON.parse(JSON.stringify(store.state.member))
						info.member = result
						commit('SET_MEMBER', info)
					}

				}
			})
		},
		//是否有邀请有礼
		hasinvitedetail({
			commit
		}, e) {
			return new Promise((resolve, reject) => {
				Vue.prototype.$http
					.invitedetail({
						parentId: '',
					})
					.then(({
						success,
						result
					}) => {
						resolve(success)
					})
			})
		},
		//是否有运营卡券
		hasgetRunEcardMemberById({
			commit
		}, e) {
			return new Promise((resolve, reject) => {
				Vue.prototype.$http
					.getRunEcardMemberById()
					.then(({
						success,
						result
					}) => {
						resolve(result)
					})
			})
		},
	},
	plugins: [saveLnLocal],
})

export default store
