import { mapGetters, mapMutations, mapActions } from "vuex";
import { getCurrentPage, getParam } from "@/common/util";
const shareMixin = {
  computed: {
    ...mapGetters(["memberId", "inviteCode"]),
  },
  data() {
    return {
      queryObj: {},
    };
  },
  onShareAppMessage() {
    let title, imageUrl, pathUrl;
    pathUrl = !!this.sharePath
      ? this.sharePath
      : getCurrentPage().$page.fullPath;
    pathUrl = `${pathUrl}${pathUrl.indexOf("?") != -1 ? "&" : "?"}salesManId=${
      this.inviteCode || ""
    }`;
    title = !!this.shareTitle
      ? this.shareTitle
      : `欢迎进入${this.$config.appName}`;
    if (typeof this.onShare == "function") this.onShare();
    return {
      title: title, // 转发后 所显示的title
      path: pathUrl, // 相对的路径
      imageUrl: !!this.shareImageUrl ? this.shareImageUrl : imageUrl,
    };
  },
  methods: {
    ...mapActions(["getSceneInfo"]),
    ...mapMutations(["SET_SALES_MANNID","SET_PARENTID"]),
    async getQuery(callback) {
		console.log(this.$mp)
      let query = {};
      if (this.$mp.query) {
        let { scene } = this.$mp.query;
        if (!!scene) {
          let result = decodeURIComponent(scene);
          query = getParam(result)
		  console.log(query)
        } else {
          query = this.$mp.query;
        }
		console.log(query,'query')
        let { salesManId } = query;
        if (!!salesManId) {
			this.SET_PARENTID(salesManId)
          this.SET_SALES_MANNID(salesManId);
          this.clickDMSUrl(salesManId);
		  
        }
      }

      callback(query);
    },
    async clickDMSUrl(salesManId) {
      if (!this.memberId) return;
      let data = {
        salesManId: salesManId,
        userId: this.memberId,
      };
      let { success, result } = await this.$http.clickDMSUrl(data);
    },
  },
};
export { shareMixin };
