import {
	mapGetters,
	mapMutations,
	mapActions
} from "vuex";
const mixinGlobal = {
	data() {
		return {}
	},
	methods: {
		navTo(item, index) {
			//切换首页的时候重新更新下底部导航和全局样式
			switch (item.navUrl) {
				case "index":
					// 微页面
					this.currentPage = "index";
					this.micropageId = item.navValue
					this.currentIndex = index
					this.clickType = 'switchTab'
					// uni.navigateTo({
					// 	url: `/pages/index/index?id=${item.navValue}`,
					// });
					break;
				case "Receive_coupons":
					// 优惠券
					uni.navigateTo({
						url: "/subPackages/coupons/coupons",
					});
					break;
				case "commodityList":
					// 点击跳转商品列表
					uni.navigateTo({
						url: `/subPackages/productlist/productlist?id=${item.id}`,
					});
					break;
				case "teams":
					// 跳搜索页面
					uni.navigateTo({
						url: `/subPackages/productSearch/productSearch`,
					});
					break;
				case "collageList":
					// 拼团列表
					uni.navigateTo({
						url: `/subPackages/groupbooking/groupbooking`,
					});
					break;
				case "category":
					// 特惠/分类
					this.currentPage = "category";
					break;
				case "zidingyi":
					// 自定义外链
					uni.navigateTo({
						url: `/subPackages/webView/webView?url=${item.url}`,
					});
					break;
				case "IntegralMall":
					// 自定义外链
					uni.navigateTo({
						url: `/subPackages/integrals/integrals`,
					});
					break;
				case "productGroup":
					// 商品组
					uni.navigateTo({
						url: `/subPackages/productGroup/productGroup?id=${item.navValue}&groupName=${item.navName}`,
					});
					break;
				case "goodGroup":
					// 商品组
					uni.navigateTo({
						url: `/subPackages/productGroup/productGroup?id=${item.navValue}&groupName=${item.navName}`,
					});
					break;
				case "detail":
					uni.navigateTo({
						url: `/subPackages/productdetails/productdetails?id=${item.navValue}`,
					});
					break;
				case "shopCar":
					//购物车
					this.currentPage = "shopCar";
					break;
				case "Personal":
					//个人中心
					this.currentPage = "Personal";
					break;
				case "Order":
					//我的订单
					uni.navigateTo({
						url: "/pages/orders/orders?tabCurrentIndex=0",
					});
					break;
				case "address":
					//收货地址
					uni.navigateTo({
						url: "/subPackages/address/address",
					});
					break;
				default:
					this.currentPage = "home";
					this.micropageId = "";
					this.currentIndex = 0;;
					this.clickType = 'switchTab';
					break;
			}
		},
	}
}
export {
	mixinGlobal
};