import {
	isH5,
	isMp
} from '@/common/platform'
import $store from '@/store/index.js'
import api from '@/api/api.js';
import ports from '@/common/ports.js';
import moment from 'moment';
import 'moment/locale/zh-cn';
moment.locale('zh-cn');
import Vue from 'vue'

function hasPaymentMode(result, h5CallBack, success, error) {
	if (isH5) {
		let h5_web_Url = result.mwebUrl + '&redirect_url=' + location.href
		h5CallBack(h5_web_Url)
	} else {
		// uni.requestOrderPayment
		uni.requestOrderPayment({
			appId: result.addId,
			timeStamp: result.timeStamp,
			nonceStr: result.nonceStr,
			package: result.packageValue,
			signType: result.signType,
			paySign: result.paySign,
			success: function(res) {

				success('支付成功！', result)
			},
			fail: function(res) {
				error('支付失败！', result, 'none')
			},
		})
		return
	}
}

function imgUrl(url) {
	return Vue.prototype.$imgUrl + url;
}

function hasH5(result) {
	return result
}

function getParam(paraName) {
	let obj = {};
	if (paraName.indexOf('&') !== -1) {
		let arrObj = paraName.split('&');
		;
		if (arrObj.length > 1) {
			for (let i = 0; i < arrObj.length; i++) {
				let arr = arrObj[i].split('=');
				obj[arr[0]] = arr[1];
			}
		}
	} else {
		let arr = paraName.split('=');
		obj[arr[0]] = arr[1];
	}
	return obj;
}

function formatTime(time) {
	if (typeof time !== 'number' || time < 0) {
		return time
	}
	var hour = parseInt(time / 3600)
	time = time % 3600
	var minute = parseInt(time / 60)
	time = time % 60
	var second = time
	return [hour, minute, second]
		.map(function(n) {
			n = n.toString()
			return n[1] ? n : '0' + n
		})
		.join(':')
}

function formatDateTime(date, fmt = 'yyyy-MM-dd hh:mm:ss') {
	if (!date) {
		return ''
	}
	if (typeof date === 'number') {
		date = new Date(date.replace(/-/g, '/') * 1000)
	}
	var o = {
		'M+': date.getMonth() + 1, //月份
		'd+': date.getDate(), //日
		'h+': date.getHours(), //小时
		'm+': date.getMinutes(), //分
		's+': date.getSeconds(), //秒
		'q+': Math.floor((date.getMonth() + 3) / 3), //季度
		S: date.getMilliseconds(), //毫秒
	}
	if (/(y+)/.test(fmt))
		fmt = fmt.replace(
			RegExp.$1,
			(date.getFullYear() + '').substr(4 - RegExp.$1.length)
		)
	for (var k in o)
		if (new RegExp('(' + k + ')').test(fmt))
			fmt = fmt.replace(
				RegExp.$1,
				RegExp.$1.length == 1 ? o[k] : ('00' + o[k]).substr(('' + o[k]).length)
			)
	return fmt
}

function getCountDown(endTime) {
	function checkTime(i) {
		if (i < 10) {
			i = '0' + i
		}
		return i
	}
	let endT = new Date(endTime.replace(/-/g, '/'))
	let startT = new Date()
	let diff = endT.getTime() - startT.getTime()
	let day = parseInt(diff / 1000 / 60 / 60 / 24) //天
	let hours = parseInt((diff / 1000 / 60 / 60) % 24) //时
	let minutes = parseInt((diff / 1000 / 60) % 60) //分
	let seconds = parseInt((diff / 1000) % 60) //秒
	return (
		checkTime(day) +
		'天' +
		checkTime(hours) +
		'时' +
		checkTime(minutes) +
		'分' +
		checkTime(seconds) +
		'秒'
	)
}

function getDistance(lat1, lng1, lat2, lng2) {
	// lat1用户的纬度
	// lng1用户的经度
	// lat2商家的纬度
	// lng2商家的经度
	var radLat1 = Rad(lat1)
	var radLat2 = Rad(lat2)
	var a = radLat1 - radLat2
	var b = Rad(lng1) - Rad(lng2)
	var s =
		2 *
		Math.asin(
			Math.sqrt(
				Math.pow(Math.sin(a / 2), 2) +
				Math.cos(radLat1) * Math.cos(radLat2) * Math.pow(Math.sin(b / 2), 2)
			)
		)
	s = s * 6378.137
	s = Math.round(s * 10000) / 10000
	s = s.toFixed(2) + 'km' //保留两位小数
	return s
}

function formatLocation(longitude, latitude) {
	if (typeof longitude === 'string' && typeof latitude === 'string') {
		longitude = parseFloat(longitude)
		latitude = parseFloat(latitude)
	}

	longitude = longitude.toFixed(2)
	latitude = latitude.toFixed(2)

	return {
		longitude: longitude.toString().split('.'),
		latitude: latitude.toString().split('.'),
	}
}

function formatGetDateDiff(startTime, endTime, diffType) {
	//将xxxx-xx-xx的时间格式，转换为 xxxx/xx/xx的格式
	startTime = startTime.replace(/\-/g, '/')
	endTime = endTime.replace(/\-/g, '/')
	//将计算间隔类性字符转换为小写
	diffType = diffType.toLowerCase()
	var sTime = new Date(startTime) //开始时间
	var eTime = new Date(endTime) //结束时间
	//作为除数的数字
	var timeType = 1
	switch (diffType) {
		case 'second':
			timeType = 1000
			break
		case 'minute':
			timeType = 1000 * 60
			break
		case 'hour':
			timeType = 1000 * 3600
			break
		case 'day':
			timeType = 1000 * 3600 * 24
			break
		default:
			break
	}
	return parseInt((eTime.getTime() - sTime.getTime()) / parseInt(timeType))
}
// alert(GetDateDiff("2016-03-28 10:30:22","2016-03-28 10:38:22","minute"));

function getBase64ImageUrl(data) {
	/// 获取到base64Data
	var base64Data = data
	/// 通过微信小程序自带方法将base64转为二进制去除特殊符号，再转回base64
	base64Data = uni.arrayBufferToBase64(uni.base64ToArrayBuffer(base64Data))
	/// 拼接请求头，data格式可以为image/png或者image/jpeg等，看需求
	const base64ImgUrl = 'data:image/png;base64,' + base64Data
	/// 刷新数据
	return base64ImgUrl
}

function throttle(fn, context, delay, text) {
	clearTimeout(fn.timer)
	fn.timer = setTimeout(() => {
		fn.call(context, text)
	}, delay)
}

function debounce(func, wait, immediate = true) {
	let timeout = null
	return function() {
		if (timeout) clearTimeout(timeout)
		timeout = setTimeout(() => {
			func.apply(this, arguments, wait)
		})
	}
}
async function dianji(fn) {
	let that = this
	if (that.onoff) {
		that.onoff = false
		await fn()
		setTimeout(() => {
			that.onoff = true
		}, 6000)
	} else {
		//如果一直走else分支可能是你没有在页面的data下面挂载onoff:true,不然一直都会走else
	}
}
let success = 'success'
let PENDING = 'pening'
let error = 'error'
class Promise {
	constructor(callback) {
		callback(this.resolve, this.reject)
	}
	status = PENDING
	value = null
	Rerror = null
	resolve(value) {
		if (status == PENDING) {
			status = success
			this.value = value
		}
	}
	reject(Rerror) {
		if (status == PENDING) {
			status = error
			this.Rerror = Rerror
		}
	}
	then(resolve, reject) {
		if (status == success) {
			resolve(this.value)
		} else if (status == error) {
			reject(this.Rerror)
		}
	}
}
var dateUtils = {
	UNITS: {
		年: 31557600000,
		月: 2629800000,
		天: 86400000,
		小时: 3600000,
		分钟: 60000,
		秒: 1000,
	},
	humanize: function(milliseconds) {
		var humanize = ''
		for (var key in this.UNITS) {
			if (milliseconds >= this.UNITS[key]) {
				humanize = Math.floor(milliseconds / this.UNITS[key]) + key + '前'
				break
			}
		}
		return humanize || '刚刚'
	},
	format: function(dateStr) {
		var date = this.parse(dateStr)
		var diff = Date.now() - date.getTime()
		if (diff < this.UNITS['天']) {
			return this.humanize(diff)
		}
		var _format = function(number) {
			return number < 10 ? '0' + number : number
		}
		return (
			date.getFullYear() +
			'/' +
			_format(date.getMonth() + 1) +
			'/' +
			_format(date.getDate()) +
			'-' +
			_format(date.getHours()) +
			':' +
			_format(date.getMinutes())
		)
	},
	parse: function(str) {
		//将"yyyy-mm-dd HH:MM:ss"格式的字符串，转化为一个Date对象
		var a = str.split(/[^0-9]/)
		return new Date(a[0], a[1] - 1, a[2], a[3], a[4], a[5])
	},
}

function ossUpload(formData, callback) {
	let token = $store.state.member.token;
	uni.uploadFile({
		header: {
			'X-Access-Token': token
		},
		url: api.baseUrl + ports.get.upload,
		filePath: formData.file, //choostimage 返回的临时图片路径
		name: 'file',
		formData,
		success: (res) => {
			;
			let data = JSON.parse(res.data);
			callback(data);
		},
		fail: (e) => {}
	});
}

function setFileName(name) {
	var fileObj = {}
	var doctorId = uni.getStorageSync('user').pid
	fileObj.typeName = getFileType(name)
	fileObj.fileName =
		'hr_' + doctorId + '_' + getTimeNum() + '.' + fileObj.typeName
	fileObj.fileUrl = 'ic_hr' + '/' + fileObj.fileName
	return fileObj
}

function seTequestSubscribeMessage(arr, callback) {
	try {
		uni.requestSubscribeMessage({
			tmplIds: arr,
			success(res) {
				callback(res)
			},
			fail(err) {
				callback(err)
			},
		})
	} catch {
		callback()
	}
}

function getCurrentPage() {
  const pages = getCurrentPages();
  const currentPage = pages[pages.length - 1];
  return currentPage;
}
function openBusinessView(param, callback) {
	if (wx.openBusinessView) {
		let data = {
			businessType: 'weappOrderConfirm',
			extraData: {
				merchant_id: param.merchant_id || '',
				merchant_trade_no: param.merchant_trade_no || '',
				transaction_id: param.transaction_id || ''
			},
			success(res) {
				uni.showModal({
					title: '提示',
					content: JSON.stringify(res),
					cancelText: '取消',
					showCancel: false,
					confirmText: '确认',
					success(res) {},

				})
				callback()
			},
			fail(res) {
				uni.showModal({
					title: '提示',
					content: JSON.stringify(res),
					cancelText: '取消',
					showCancel: false,
					confirmText: '确认',
					success(res) {},

				})
			},
			complete(res) {
				uni.showModal({
					title: '提示',
					content: JSON.stringify(res),
					cancelText: '取消',
					showCancel: false,
					confirmText: '确认',
					success(res) {},

				})
			}
		}
		wx.openBusinessView(data)
	} else {
		uni.showModal({
			title: '提示',
			content: '当前版本不支持确认收货，请升级版本后重试',
			cancelText: '取消',
			showCancel: false,
			confirmText: '确认',
			success(res) {},

		})
	}
}

function previewImage(current, imagUrl, callback) {
	uni.previewImage({
		urls: imagUrl,
		current: current,
	});
}
module.exports = {
	openBusinessView,
	previewImage,
	hasH5,
	formatTime,
	getParam,
	imgUrl,
	formatDateTime,
	formatLocation,
	formatGetDateDiff,
	dateUtils,
	throttle,
	moment,
	debounce,
	dianji,
	getDistance,
	getBase64ImageUrl,
	ossUpload,
	getCountDown,
	seTequestSubscribeMessage,
	hasPaymentMode,
	getCurrentPage,
}
