import api from '../api/api.js'
import Vue from 'vue'
import {
	hasH5
} from '@/common/util.js'
import {
	isH5,
	isMp
} from '@/common/platform.js'
let self = Vue.prototype
export default {
	globalRequest(url, method, data, Tosat = true, loading = true) {
		let token = self.$store.state.member.token || ''
		let $http = hasH5(self.$http);
		let webType;
		const baseUrl = api.baseUrl
		if (isH5) {
			webType = 'web'
		} else if (isMp) {
			webType = 'miniApp'
		}
		return new Promise((resolve, reject) => {
			uni.request({
				url: api.baseUrl + url,
				method: method.toLocaleLowerCase(),
				data: {
					...data,
					...{
						shopId: $http.shopId,
					},
				},
				header: {
					'Content-Type': 'application/json',
					'X-Access-Token': token,
					tenantId: $http.tenantId,
					appCode: $http.appCode,
					qryShopId: $http.shopId,
					mId: self.$store.getters.memberId || '',
					webType
				},
				success(res) {
					if (res.statusCode == 200) {
						if (res.data.message.includes('操作失败')) {
							let message = res.data.message.split('操作失败，')
							res.data.message = message[message.length - 1]
						}
						if (res.data.code == 200) {
							resolve(res.data)
						} else if (res.data.message == '用户不存在!') {
							//清空存储的用户信息
							self.$store.dispatch('resetVuex')
						} else if (res.data.code == 10011) {
							uni.navigateBack({
								delta: 1,
							})
						} else {
							console.log('获取失败')
							resolve(res.data)
						if(Tosat) uni.showToast({
								title: res.data.message,
								duration: 3000,
								icon: 'none',
							})
						}
					} else {
						const data = (res.data && res.data.message) || '';
						if (data == 'Token失效，请重新登录') {
							uni.clearStorageSync();
						} else {
							if(Tosat) uni.showToast({
								title: res.data.message,
								duration: 3000,
								icon: 'none'
							});
							resolve(res.data || {});
						}
					}
				},
				error(res) {},
			})
		})
	},
}
