import ports from '../common/ports.js'
import distributionPorts from '../common/distributionPorts.js' //分销模块
import request from '../common/request.js'
import config from '@/config/index.js';
let api = {}
api['appId'] = config.appId //小程序appid
api['tenantId'] = config.tenantId //租户id
api['appCode'] = config.appCode //区分门店端或者商城端
api['imgUrl'] = config.imgUrl //图片前缀
api['baseUrl'] = config.baseUrl //api请求地址
api['shopId'] = config.shopId //商城门店Id
let arr = []
if(ports) arr.push(ports)
if(distributionPorts) arr.push(distributionPorts)
arr.forEach(item => {
	Object.keys(item.get).map(key => {
		api[key] = (params, Toast, loading=false) => request.globalRequest(item.get[key], 'get',  params, Toast, loading)
	})
	Object.keys(item.post).map(key => {
		api[key] = (params, Toast, loading=false) => request.globalRequest(item.post[key], 'post',  params, Toast, loading)
	})
	Object.keys(item.deleted).map(key => {
		api[key] = (params, Toast, loading=false) => request.globalRequest(item.deleted[key], 'delete',  params, Toast, loading)
	})
	Object.keys(item.put).map(key => {
		api[key] = (params, Toast, loading=false) => request.globalRequest(item.put[key], 'put',  params, Toast, loading)
	})
})

export default api
