import axios from '@/api/api.js' //接口
import $store from '@/store/index.js'
export const decState = {
	//首页数据
	homeData: {
		micropageId: '',
		productShow: false, //商品弹窗
		good: {}, //弹窗数据
		hasUpdateMemberCart: true, //防止购物车重复添加的标识
		currentPage: 'home', //页面当前page标识
		cartCont: 0, //购物车数量
		productConfig: {
			productType: 'SP', //sp普通商品   pt拼团商品
			popupType: 1, //弹窗类型    1是普通商品购物车 2是普通商品立即购买 3是拼团单独购买 4是拼团我要开团
		},
	},
}
export const decAxios = {
	decImgDomain: function(url, staticImg = 'goods.png') {
		const $decStaticImgUrl =
			'https://tikcos.oss-cn-beijing.aliyuncs.com/decOnlineImg/'
		if (url) {
			return url
		} else {
			return $decStaticImgUrl + staticImg
		}
	},
	decEventHandler: function(e, arg) {
		let self = this
		let homeData = decState.homeData
		console.log(e,'打印e')
		switch (e) {
			case 'toGoodDetail':
				// 进入商品详情
				uni.navigateTo({
					url: '/subPackages/productdetails/productdetails?id=' + arg.id,
				})
				break
			case 'goodToCart':
				// 添加弹出购物车弹窗
				return getProductDetail
				break
			case 'receiveCoupon':
				// 点击领取优惠券
				if (!this.$store.getters.isLogin) {
					uni.navigateTo({
						url: '/subPackages/login/login',
					})
					return
				}
				let {
					integral, exchangeType
				} = arg
				uni.navigateTo({
					url: `/subPackages/packages/index?currentTab=${
            integral == 0 && exchangeType == 1 ? '0' : '1'
          }&id=${arg.id}`,
				})
				break
			case 'toSearchPage':
				// 跳搜索页面
				uni.navigateTo({
					url: '/subPackages/productSearch/productSearch',
				})
				break
			case 'toUserPage':
				// 跳个人中心

				homeData.currentPage = 'Personal'
				uni.navigateTo({
					url: '/pages/globalPage/index'
				});
				break
			case 'coupons':
				// 跳优惠券
				uni.navigateTo({
					url: '/subPackages/coupons/coupons',
				})
				break
				//图文导航跳转
			case 'toNav':
				return toNav
				break
				//我的地址
			case 'address':
				uni.navigateTo({
					url: '/subPackages/address/address',
				})
				break
				//商品详情
			case 'tocollagePage':
				uni.navigateTo({
					url: `/subPackages/productdetails/productdetails?grouponId=${arg.id}&sence=groupbooking`,
				})
				break
			default:
				break
		}

		function toNav(link, item) {
			let id = link.argValue
			console.log(link,'linkAdd')
			switch (link.path) {
				case 'index':
					if (!link.argValue || !link.argName) {
						return
					}
					// homeData.currentPage = 'index';
					// homeData.micropageId = id;

					uni.navigateTo({
					    url: `/pages/index/index?id=${id}&name=${link.argName}`,
					})
					break
				case 'Receive_coupons':
					// 优惠券
					uni.navigateTo({
						url: '/subPackages/coupons/coupons',
					})
					break
				case 'commodityList':
					// 点击跳转商品列表
					if (!link.argValue || !link.argName) {
						return
					}
					uni.navigateTo({
						url: `/subPackages/productlist/productlist?id=${id}&cateName=${item.title}`,
					})
					break
				case 'teams':
					// 跳搜索页面
					uni.navigateTo({
						url: `/subPackages/productSearch/productSearch`,
					})
					break
				case 'collageList':
					// 拼团列表
					uni.navigateTo({
						url: `/subPackages/groupbooking/groupbooking`,
					})
					break
				case 'groupbooking':
					// 拼团列表
					let params = JSON.stringify(item)
					uni.navigateTo({
						url: `/subPackages/groupbooking/groupbooking?params=${params}`,
					})
					break
				case 'category':
					// 特惠/分类
					homeData.currentPage = 'category'
					uni.reLaunch({
						url: '/pages/globalPage/index'
					});
					break
				case 'zidingyi':
					// 自定义外链
					uni.navigateTo({
						url: `/subPackages/webView/webView?url=${link.argName}`,
					})
					break
				case 'IntegralMall':
					//积分商城
					uni.navigateTo({
						url: `/subPackages/integrals/integrals`,
					})
					break
				case '"goodGroup"':
					// 商品组
					if (!link.argValue || !link.argName) {
						return
					}
					uni.navigateTo({
						url: `/subPackages/productGroup/productGroup?id=${id}&groupName=${item.title}`,
					})
					break
				case 'productGroup':
					// 商品组
					uni.navigateTo({
						url: `/subPackages/productGroup/productGroup?id=${id}&groupName=${item.title}`,
					})
					break
				case 'detail':
					//商品详情
					if (!link.argValue || !link.argName) {
						return
					}
					uni.navigateTo({
						url: `/subPackages/productdetails/productdetails?id=${id}`,
					})
					break
				case 'shopCar':
					//购物车
					homeData.currentPage = 'shopCar'
					uni.reLaunch({
						url: '/pages/globalPage/index'
					});
					break
				case 'Personal':
					//个人中心
					homeData.currentPage = 'Personal'
					uni.reLaunch({
						url: '/pages/globalPage/index'
					});
					break
				case 'Order':
					//我的订单
					uni.navigateTo({
						url: '/pages/orders/orders?tabCurrentIndex=0',
					})
					break
				case 'address':
					//收货地址
					uni.navigateTo({
						url: '/subPackages/address/address',
					})
					break
					//首页
				default:
				console.log(link.pathName,'link.pathName')
				if(link.pathName=='外链'){
					uni.navigateTo({
						url: `/subPackages/webView/webView?url=${link.argName}`,
					})
				}else{
					homeData.currentPage = 'home'
					uni.navigateTo({
						url: '/pages/globalPage/index'
					});
				}
					break
					
			}
		}
		//领取卡券
		function buyEcardCenter(data) {
			if (!this.$store.getters.isLogin) {
				uni.navigateTo({
					url: '/subPackages/login/login',
				})
				return
			}
			uni.showLoading({
				title: '领取中...',
			})
			this.$http.buyEcardCenter(data).then(({
				success,
				result
			}) => {
				setTimeout(function() {
					uni.hideLoading()
				}, 2000)
				if (success) {
					uni.showToast({
						title: '领取成功！',
						icon: 'scuccess',
						duration: 1000,
					})
					this.receiveSuccess(data)
				}
			})
		}
		//获取商品详情拿到productItem
		function getProductDetail(res) {
			let homeData = decState.homeData
			let data = {
				productId: res.id,
			}
			axios.getProductDetail(data).then(({
				success,
				result
			}) => {
				if (success) {
					result.productCustomKeyRespList.forEach((e) => {
						e.customKeyRespList.forEach((i, index) => {
							if (index == 0) {
								this.$set(i, 'is_default', 1)
							}
						})
					})

					homeData.good = result //将数据赋给弹窗
					homeData.productShow = true //弹窗
				}
			})
		}
	},
	//关闭弹窗
	closeCallBack() {
		decState.homeData.productShow = false
	},
	// 打开弹窗
	openCallBack() {
		decState.homeData.productShow = true
	},
	//加入购物车
	updateMemberCartAddOrReduce(action, info) {
		let homeData = decState.homeData
		let {
			good
		} = homeData
		let {
			count
		} = info
		if (!$store.getters.isLogin) {
			uni.navigateTo({
				url: '/subPackages/login/login',
			})
			return
		}
		if (!homeData.hasUpdateMemberCart) {
			return
		}
		homeData.hasUpdateMemberCart = false
		let data = {
			action: action,
			count: count,
			productId: good.id,
			productItemId: this.getGoodProductItemId(good).id,
			productName: good.productName,
			shopId: $store.shopId,
			specContent: this.getGoodSelectedProps(good),
		}
		axios.updateMemberCartAddOrReduce(data).then(({
			success,
			result
		}) => {
			if (success) {
				homeData.hasUpdateMemberCart = true
				this.closeCallBack()
				this.getMemberCartList()
				uni.showToast({
					title: '添加成功!',
					icon: 'success',
					duration: 3000,
				})
			}
		})
	},
	//立即购买
	handleBuyItNow(info) {
		let url = '/subPackages/pay/pay'
		let homeData = decState.homeData
		let {
			good
		} = homeData
		let {
			count,
			salePrice
		} = info
		let {
			productType,
			popupType
		} = homeData.productConfig
		let productItemId =
			this.getGoodProductItemId(good) && this.getGoodProductItemId(good).id
		let cart = []
		if (!$store.getters.isLogin) {
			uni.navigateTo({
				url: '/subPackages/login/login',
			})
			return
		}
		const product = Object.assign({}, good, {
			specContent: this.getGoodSelectedProps(good),
			props: this.getGoodSelectedProps(good, 'id'),
			productItemId,
			count: count,
		})
		let {
			grouponPrice
		} = product
		if (popupType == 4) {
			//我要开团 4
			product.salePrice = grouponPrice
			url = `${url}?scene=groupbooking&grouponId=${good.id}`
		} else if (popupType == 3) {
			//单独购买 3
			product.salePrice = salePrice
			url = `${url}?scene=productdetails&productItemId=${good.itemId}`
		} else {
			//立刻购买 2
			product.salePrice = salePrice
			url = `${url}?scene=productdetails&productItemId=${productItemId}`
		}
		cart.push(JSON.parse(JSON.stringify(product)))
		$store.commit('SET_CART', cart)
		uni.navigateTo({
			url: url,
		})
	},
	//获取规格id
	getGoodProductItemId(good) {
		if (good.specConfig == 'Y' && good.productItemRespList.length > 0) {
			return (
				good.productItemRespList.find((item) => {
					return this.getGoodSelectedProps(good, 'id') == item.specCustom
				}) || {}
			)
		} else if (good.specConfig == 'N') {
			return good.productItemRespList[0]
		}
		return ''
	},
	//计算当前饮品所选属性
	getGoodSelectedProps(good, type = 'text') {
		if (good.specConfig == 'Y') {
			let props = []
			good.productCustomKeyRespList.forEach(({
				customKeyRespList
			}) => {
				customKeyRespList.forEach((value) => {
					if (value.is_default) {
						props.push(type === 'text' ? value.keyName : value.id)
					}
				})
			})
			return props.join(',')
		}
		return ''
	},
	//获取购物车
	getMemberCartList() {
		if (!$store.getters.isLogin) {
			return
		}
		let homeData = decState.homeData
		// 
		let data = {
			shopId: $store.shopId,
		}
		axios.getMemberCartList(data).then(({
			success,
			result
		}) => {
			if (success) {
				homeData.cartCont = result.sumCount
			}
		})
	},
	getInfo: function(params) {
		if (params && params.id) {
			return new Promise((resolve) => {
				axios.getMicroPageById(params).then((res) => {
					if (res.code == '200') {
						resolve({
							code: '200',
							result: {
								pageLayout: res.result[0] && res.result[0].page_layout,
							},
						})
					}
				})
			})
		} else {
			return new Promise((resolve) => {
				axios.getHomePage().then((res) => {
					if (res.code == '200') {
						resolve({
							code: '200',
							result: {
								pageLayout: res.result[0] && res.result[0].page_layout,
							},
						})
					} else {
						resolve({
							code: '200',
							result: test.result,
						})
					}
				})
			})
		}
	},
	getShopLogo(params) {
		return axios.getshopLogo(params)
	},
	goodList: {
		getDataByIds(params) {
			return axios.getProductListPage(params)
		},
	},
	toBargain: {
		getDataByIds(params) {
			return axios.getProductListPage(params)
		},
	},
	toShopping: {
		getDataByIds(params) {
			return axios.getUmpGrouponList(params)
		},
	},
	shopCoupon: {
		getDataByIds(params) {
			// ids getType getCount
			return axios.getUmpEcardTrimListByIds(params)
		},
	},
	goodGroup: {
		getDataByIds(params) {
			// ids
			return axios.getProductGroupByIds(params)
		},
	},

}