import axios from '@/api/api.js'; //接口
import { ossUpload } from '@/common/util.js';
const COS = require('cos-wx-sdk-v5');
const uploadMixin = {
  data() {
    return {
      uploadMixinPath: '',
      uploadMixinType: '',
      uploadMixinCredentials: {},
      uploadMixinTimeStamp: 0
    };
  },
  methods: {
    upLoadFilesHander(tempFilePaths, tempFiles, zip){
      return new Promise((resolve)=>{
        if (tempFiles.length != 0) {
          if(typeof this.upLoadHander !== 'function') return;
          let uploadObj = {};
          let uploadNum = tempFiles.length;
          uploadObj.length = tempFiles.length;
          //处理上传结果函数
          function loadHandler({ success, message },i){
            uploadNum = uploadNum - 1;
            uploadObj[i] = message;
            if (!success) {
              uploadObj[i] = '';
              uni.showToast({
                title: `[${i+1}]上传失败，请重新上传！`,
                icon: 'none',
                duration: 2000
              });
            }
            if (uploadNum == 0) {
              const arr = Array.from(uploadObj);
              // ;
              resolve({success: true, result: arr})
            }
          }
          //进行上传
          tempFiles.forEach((file, i) => {
            this.upLoadHander({
              path: tempFilePaths[i],
              file: file.path,
              zip: zip || '',
              onSuccess: ({ success, message }) => {
                loadHandler({ success, message },i)
              },
              onError: (res) => {
                loadHandler({ success: false, message:''}, i)
              }
            });
          });
        }else{
          resolve({success: true,result: []})
        }
      });
    },
    upLoadHander(obj) {
      const { path, file, biz} = obj;
      const pathArr = (path || '').split('/');
      const pathStr = pathArr[pathArr.length -1];
      const fileName = (pathStr || '').split('.');
      let fileInfo = {
        fileTyle: fileName.length > 1 ? fileName[fileName.length - 1] : '',
        fileName: fileName[0],
        biz: biz || 'temp',
        file: file
      };

      const that = this;
      const none = (async function hander(noCredentials) {
        let res = {},
          staticDomain = '',
          resResult = true;
        //noCredentials变量控制是否走对象存储
        if (noCredentials) {
          res = await axios.getUploadConfigInfo();
          if (res.code === 200 && res.result) {
            that.uploadMixinPath = res.result.upLoadPath;
            that.uploadMixinType = res.result.uploadType;
            staticDomain = res.result.staticDomain || 'https://cdn.tikcos.cn';
            if (that.uploadMixinType === 'txcos') {
              const ress = res.result.response;
              const credentials = ress.credentials;
              that.uploadMixinCredentials = {
                TmpSecretId: credentials.tmpSecretId,
                TmpSecretKey: credentials.tmpSecretKey,
                SecurityToken: credentials.sessionToken,
                StartTime: ress.startTime,
                ExpiredTime: ress.expiredTime
              };
            }
          } else {
            resResult = false;
          }
        }
        //resResult判断接口是否正常
        if (resResult) {
          if (that.uploadMixinType == 'txcos') {
            //走对象存储
            const cos = new COS({
              getAuthorization: (options, callback) => {
                callback(that.uploadMixinCredentials);
              }
            });
            const tempFolder = fileInfo.biz === 'temp' ? '' : `${fileInfo.biz}/`;
            const folder = `${fileInfo.fileName}_${new Date().getTime()}.${fileInfo.fileTyle}`;
            cos.postObject(
              {
                FilePath: fileInfo.file,
                Bucket: res.result.bucketName || 'tikcos-1257774783',
                Region: res.result.regionid || 'ap-guangzhou',
                Key: that.uploadMixinPath + tempFolder + folder,
                Body: fileInfo.file,
                onProgress: function (progressData) {
                  obj.onProgress && obj.onProgress(progressData);
                }
              },
              (err, data) => {
                if (!err && data.statusCode === 200) {
                  const imgurl = `${staticDomain}/${that.uploadMixinPath}${tempFolder}${folder}`;
                  obj.onSuccess({
                    success: true,
                    message: imgurl
                  });
                } else {
                  obj.onError({
                    success: false,
                    message: err || '图片上传失败'
                  });
                }
              }
            );
          } else {
            //走系统上传
            ossUpload(
              {
                biz: fileInfo.biz,
                file: fileInfo.file
              },
              (uploadRes) => {
                // ;
                if (uploadRes.success && uploadRes.message) {
                  //保存绝对路径，不然小程序会有问题
                  let url = uploadRes.message;
                  const pre = url.startsWith('/') ? '' : '/';
                  url = axios['imgUrl'] + url;
                  obj.onSuccess({ success: true, message: url });
                } else {
                  obj.onError({
                    success: false,
                    message: uploadRes.message || '图片上传失败'
                  });
                }
              }
            );
          }
        } else {
          obj.onError({
            success: false,
            message: '服务接口报错'
          });
        }
      })(true);
    },
    setOssUpload(obj) {
      ossUpload(
        {
          biz: obj.biz,
          file: obj.file
        },
        (uploadRes) => {
          if (uploadRes.success && uploadRes.message) {
            //保存绝对路径，不然小程序会有问题
            let url = uploadRes.message;
            const pre = url.startsWith('/') ? '' : '/';
            url = axios['imgUrl'] + url;
            obj.onSuccess({ success: true, message: url });
          } else {
            obj.onError({
              success: false,
              message: uploadRes.message || '图片上传失败'
            });
          }
        }
      );
    }
  }
};
export { uploadMixin };
