import _shopTab from "./shopTab/index";
import _shopHome from "./shopHome/index";
import _shopIndex from "./shopIndex/index";
import _shopStyle from "./shopStyle/index";
import _shopLink from "./shopLink/index";
import linkModal from "./modal/linkBox.js";
import "./index.less";
const components = {
  linkModal,
  shopTab: _shopTab,
  shopHome: _shopHome,
  shopIndex: _shopIndex,
  shopStyle: _shopStyle,
  shopLink: _shopLink,
};
const install = function (Vue, _opts = {}) {
  // 判断是否安装
  if (install.installed) return;
  install.installed = true;
  // 遍历注册全局组件
  Object.keys(components).forEach((key) => {
    Vue.component(components[key].name, components[key]);
  });
};
export const shopHome = _shopHome;
export const shopIndex = _shopIndex;
export const shopTab = _shopTab;
export const shopStyle = _shopStyle;
export const shopLink = _shopLink;
export const linkBox = linkModal;
export default {
  install,
};
