// referW参考高度
// imgH图片样式
function imgLoad(e, ins) {
  var rect = uni.getSystemInfoSync();
  var dataset = e.target.dataset;
  var isFirst = (dataset && dataset.first) || false;
  var res = {};
  if (!isFirst) return;
  res = (function computer(e, dataset, rect) {
    var num = (dataset && dataset.num) || 1;
    var space = parseInt((dataset && dataset.space) || 0);
    var lacuna = parseInt(num == 1 ? 0 : (dataset && dataset.lacuna) || 0);
    var vw =
      parseInt(((rect.windowWidth - 2 * space + lacuna) / num) * 100) / 100;
    var cw = e.detail.width;
    var ch = e.detail.height;
    var nh = parseInt((vw / cw) * ch * 100) / 100;
    return {
      imgW: vw,
      imgH: nh || 100,
      space: space,
      lacuna: lacuna,
    };
  })(e, dataset, rect);
  if (res.space > 0) {
    ins.$el.style.paddingLeft = res.space + "px";
    ins.$el.style.paddingRight = res.space + "px";
  }
  if (res.lacuna != 0) {
    ins.$el.style.marginLeft = 0 - res.lacuna + "px";
  }
  var arr = ins.selectAllComponents(".imgH");
  var len = arr.length;
  for (var i = 0; i < len; i++) {
    arr[i].setStyle({
      height: res.imgH + "px",
      width: res.imgW + "px",
      "padding-left": res.lacuna + "px",
    });
  }
}
export default imgLoad;
