const path = require("path");
const CopyWebpackPlugin = require("copy-webpack-plugin");
const data = require("./mock.js");

module.exports = {
  lintOnSave: false,
  // 多页面配置
  pages: {
    // 开发入口
    shopLink: {
      entry: "test/shopLink.js",
      template: "public/index.html",
    },
    // 管理入口
    index: {
      entry: "test/shopHome.js",
      template: "public/index.html",
    },
    //底部导航页面
    shopTab: {
      entry: "test/shopTab.js",
      template: "public/index.html",
    },
    // 店铺风格页面
    shopStyle: {
      entry: "test/shopStyle.js",
      template: "public/index.html",
    },
  },
  // configureWebpack是对象就是合入，是方法就直接修改配置
  devServer: {
    after: (app) => {
      if (!app) {
        throw new Error("webpack-dev-server is not defined");
      }
      data.mock(app);
    },
    proxy: {
      "/center": {
        target: "http://merchant.wstore.me",
        changeOrigin: true,
      },
      // '/design': {
      //   target: 'http://192.168.101.154:3002/api',
      //   changeOrigin: true
      // }
    },
  },
  configureWebpack(config) {
    // 插件处理 process.env.NODE_ENV
    console.log("NODE_ENV:", process.env.NODE_ENV);
    if (process.env.NODE_ENV === "production") {
      config.plugins.push(
        new CopyWebpackPlugin([
          {
            from: path.resolve(__dirname, "public/static"),
            to: path.resolve(__dirname, "lib"),
          },
        ])
      );
    }
  },
};
