// 右侧设置参数
import axios from "../util/ajax.js";
const sourceMap = {
  pageSet: "2",
  imageLink: "2",
  shopBase: "2",
  shopCoupon: "1",
  shopLogo: "1",
  shopFront: "5",
  shopNav: "3",
  shopNotice: "1",
  shopSearch: "1",
  videoLink: "3",
  voiceLink: "3",
  imageBlock: "2",
};
const $isEmptyObj = function (val) {
  if (typeof val === "object") {
    const str = JSON.stringify(val);
    return str === "{}" || str === "[]" ? true : false;
  }
  return !val;
};
// 标签-tag
export const decState = {
  pageSet: {
    id: "pageSet",
    type: "pageSet",
    name: "页面配置",
    pageName: "微页面标题", // 页面名称
    pageDesc: "页面描述", // 页面描述
    bgImg: "", // 背景图片
    bgImgW: 100, // 背景图片宽度比
    bgColor: "", // 页面背景色
    repeat: false, // 背景图片平铺
    fix: false,
  },
  shopBase: {
    id: "shopBase",
    type: "shopBase",
    name: "顶部导航",
    mode: "", // 原生-高级custom
    styleArg: "", //fix
    fontColor: "black",
    lIcon: "back",
    lIconImg: "",
    lIconLink: {},
    title: "text", // text down
    search: false,
    searchBg: "#f7f8ff",
    rIcon: false,
    rIconFn: [],
    rIconImg: "",
    rIconCc: true,
    rIconLink: {},
  },
  shopFront: {
    icon: { id: 1, type: "shopFront", name: "店招", tag: "base" },
    arg: {
      styleArg: "type4",
      shopName: "瓜瓜小店",
      intro: "我是小可爱啊，挂画小店",
      bgImg: "", //背景图片
      logoImg: "", // logo图
    },
    valid: function (arg) {
      if (!arg.bgImg) {
        return { result: false, message: "请选择背景图片!" };
      } else if (!arg.logoImg) {
        return { result: false, message: "请选择logo图!" };
      }
    },
  },
  shopSearch: {
    icon: { id: 2, type: "shopSearch", name: "搜索框", tag: "base" },
    arg: {
      styleArg: "ordinary", // 搜索样式-ordinary-top
      outColor: "transparent", // top背景色
      inColor: "#ffffff", // top框底色
      fontColor: "#333333", //字体颜色【2022新增】
      border: false, //是否显示边框【2022新增】
      radius: true, //边框圆角【2022新增】
      rightImg: "", //右侧功能图【2022新增】
      linkArg: {}, //右侧链接地址【2022新增】
    },
  },
  showBlank: {
    icon: { id: 3, type: "showBlank", name: "辅助空白", tag: "base" },
    arg: {
      value: 30, // 空白高
    },
  },
  showLines: {
    icon: { id: 4, type: "showLines", name: "辅助线", tag: "base" },
    arg: {
      color: "#DDDDDD",
      margin: "yes",
      lineStyle: "solid",
    },
  },
  shopNav: {
    icon: { id: 5, type: "shopNav", name: "图文导航", tag: "base" },
    arg: {
      styleArg: "group", // 一行:row 分组:group
      rowNum: 4, // 一行多少个【2022新增】
      iconStyle: "top", // top left no
      iconSize: 40, // 导航图标大小
      bgColor: "transparent", // 导航背景颜色【2022新增】
      space: 10, //组间距=上下边距
      color: "#000", // 导航项文字颜色【2022新增】
      ids: [], // 导航项数据
    },
    valid: function (arg) {
      const ids = arg.ids;
      if (ids.length === 0) {
        return { result: false, message: "请添加导航项！" };
      } else {
        for (let j = 0; j < ids.length; j++) {
          if (!ids[j].img) {
            return { result: false, message: "请选择导航图片！" };
          } else if ($isEmptyObj(ids[j].linkArg)) {
            return { result: false, message: "请选择导航路径！" };
          }
        }
        return { result: true };
      }
    },
  },
  goodList: {
    icon: { id: 8, type: "goodList", name: "商品列表", tag: "base" },
    arg: {
      static: false,
      import: false, //支持导入
      styleArg: "fix", // 数据固定fix 接口获取api
      concat: true, //需要自定加载数据
      autoLoad: "N",
      dataNum: 6, // 接口获取方式展示的数据量
      ids: [], // 固定的数据id集:ids
      listStyle: "double", // row-one row-two row-family colum-list
      layout: "",
      show: {
        border: "", //商品框样式
        radius: true, // 是否圆角
        name: true, // 显示商品名字
        nameStyle: "", //字图风格
        price: true, // 显示商品价格
        origin: true, // 显示市场价
        bug: true, // 显示购买按钮
        bugStyle: "plus", // plus shop custom
        bugTxt: "", // 自定义按钮文案
        mark: true, // 显示商品角标
        markStyle: "hot1", // 图片名字：new2 hot2 new hot
        desc: true, // 显示商品描述
        descTxt: "", // 统一描述字段--待用
        shopName: false, //显示所属店铺
        postType: false, //发货类型
        reward: false, //佣金奖励
      },
    },
    valid: function (arg) {
      if (arg.styleArg === "fix" && arg.ids.length === 0) {
        return { result: false, message: "请选择商品" };
      }
    },
  },
  blockTitle: {
    icon: { id: 9, type: "blockTitle", name: "标题", tag: "base" },
    arg: {
      title: "", // 标题
      titleStyle: "left", // left center
      more: "yes", // 显示更多按钮：yes no
      linkArg: {},
    },
    valid: function (arg) {
      //标题检测-请填写标题-请填写表填链接
      if (!arg.title) {
        return { result: false, message: "请填写标题" };
      } else if (arg.more === "yes" && $isEmptyObj(arg.linkArg)) {
        return { result: false, message: "请选择标题组件的更多链接" };
      }
    },
  },
  descText: {
    icon: { id: 10, type: "descText", name: "文本", tag: "base" },
    arg: {
      title: "",
      size: "big",
      color: "#000",
      bgColor: "transparent",
      position: "left",
    },
    valid: function (arg) {
      if (!arg.title) return { result: false, message: "文本不能为空" };
    },
  },
  richText: {
    icon: { id: 11, type: "richText", name: "富文本", tag: "base" },
    arg: {
      content: "",
      bgColor: "transparent",
    },
    valid: function (arg) {
      if (!arg.content) {
        return { result: false, message: "富文本内容不能为空！" };
      }
    },
  },
  imageLink: {
    icon: { id: 12, type: "imageLink", name: "广告模块", tag: "base" },
    arg: {
      styleArg: "carousel",
      rowNum: "1",
      margin: "no",
      isBackground: false, //是否为背景图
      radius: true,
      space: 0, //页边距【2022新增】
      lacuna: 0, //图间距【2022新增】
      ids: [], // 项数据
      taps: [], // 热区数据【2022新增】
    },
    valid: function (arg) {
      const ids = arg.ids,
        taps = arg.taps;
      if (ids.length === 0) {
        return { result: false, message: "请添加对应的广告项" };
      } else if (arg.styleArg == "tap") {
        for (let j = 0; j < taps.length; j++) {
          if ($isEmptyObj(taps[j].linkArg))
            return { result: false, message: "请选择广告热区链接" };
        }
      } else {
        for (let j = 0; j < ids.length; j++) {
          if (!ids[j].img) return { result: false, message: "请选择广告图" };
          if ($isEmptyObj(ids[j].linkArg))
            return { result: false, message: "请选择广告链接" };
        }
      }
    },
  },
  voiceLink: {
    icon: { id: 13, type: "voiceLink", name: "语音", tag: "base" },
    arg: {
      styleArg: "weChat", // 选择风格weixin - simple
      source: "", // 资源信息
      play: "again", // 播放方式 again continue
      listStyle: "left", // left right
      titleImg: "", // 头像
      title: "", // 文本
      loop: true, // 是否循环播放
    },
    valid: function (arg) {
      if (!arg.source) return { result: false, message: "请选择音频" };
    },
  },
  videoLink: {
    icon: { id: 14, type: "videoLink", name: "视频", tag: "base" },
    arg: {
      source: "",
      cover: "", //封面图片【2022新增】
      ratio: "", //分辨率【2022新增】,
      isSkip: "", //跳转图标
      linkArg: {}, //右侧链接地址【2023新增】
    },
    valid: function (arg) {
      if (!arg.source) return { result: false, message: "请填写视频链接" };
      if (arg.isSkip == "yes" && !arg.linkArg.path)
        return { result: false, message: "请填写图标链接" };
      if (arg.isSkip == "yes" && !arg.linkArg.tagImg)
        return { result: false, message: "请上传跳转图标" };
    },
  },
  shopNotice: {
    icon: { id: 15, type: "shopNotice", name: "公告", tag: "base" },
    arg: {
      styleArg: "static", // static 滚动scroll
      title: "",
      bgColor: "#FFF5E7",
      color: "#999999",
      leftIcon: "",
    },
    valid: function (arg) {
      if (!arg.title) return { result: false, message: "请填写公告" };
    },
  },
  shopTel: {
    icon: { id: 16, type: "shopTel", name: "客服电话", tag: "base" },
    arg: {
      title: "客服电话",
      tel: "",
    },
    valid: function (arg) {
      if (!arg.tel) return { result: false, message: "请填写电话" };
    },
  },
  imageBlock: {
    icon: { id: 18, type: "imageBlock", name: "图块", tag: "base" },
    arg: {
      img: "", //图片
      feedId: null, //feedId
      finderUserNameId: null, //finderUserNameId
      IsRelevance: false, //false 普通图块  true 打开选择视频号开关
      lsActivity: "no", //是关联视频号  'yes'关联 'no'不关联
    },
    valid: function (arg) {
      if (!arg.img) {
        return { result: false, message: "请选择图块图片！" };
      }
      if (arg.IsRelevance && !arg.finderUserNameId) {
        return { result: false, message: "请选择finderUserNameId！" };
      }
      if (arg.IsRelevance && !arg.feedId) {
        return { result: false, message: "请选择feedId！" };
      }
    },
  },
  //限时抢购
  goodDiscount: {
    icon: { id: 21, type: "goodDiscount", name: "限时抢购", tag: "market" },
    arg: {
      id: [], // 活动信息
      listStyle: "scroll", //list one two three scroll
      space: 10, //页面边距
      lacuna: 10, //商品间距
      show: {
        ratio: "1-1", //图片比例
        border: "", // 无边白底:''，卡片投影:'shadow',描边白底: 'border',无边透明底：'none'
        radius: "", // 直角，圆角-'yes'
        imgFill: "", // 'widthFix'  'aspectFit'
        fontWeight: "normal", // 'normal' bold
        title: true,
        desc: true,
        price: true,
        buy: true,
        shop: "1", // 1,2,3,4,5,6
        shopText: "马上抢",
        origin: true, // 市场价
        stock: true, // 库存
        time: true, // 抢购倒计时
        speed: true, // 抢购进度条
      },
    },
    valid: function (arg) {
      if (!(arg.id || {}).id) {
        return { result: false, message: "请选择折扣活动" };
      }
    },
  },
  //专区商品
  goodSpecial: {
    icon: { id: 22, type: "goodSpecial", name: "专区商品", tag: "market" },
    arg: {
      bgColor: "transparent", // 模块底色
      radius: 0, // 模块圆角
      space: 0, // 模块边距
      bgSize: 100, // 模块大小
      id: "", // 选择的专区商品信息
    },
    valid: function (arg) {
      if (!(arg.id || {}).id) {
        return { result: false, message: "请选择专区商品" };
      }
    },
  },
  //优惠限购-类似专区商品
  goodFine: {
    icon: { id: 22, type: "goodFine", name: "优惠限购", tag: "market" },
    arg: {
      bgColor: "transparent", // 模块底色
      radius: 0, // 模块圆角
      space: 0, // 模块边距
      bgSize: 100, // 模块大小
      id: "", // 选择的优惠活动信息
    },
    valid: function (arg) {
      if (!(arg.id || {}).id) {
        return { result: false, message: "请选择优惠限购活动" };
      }
    },
  },
  goodIntegral: {
    icon: { id: 23, type: "goodIntegral", name: "积分商品", tag: "base" },
    arg: {
      styleArg: "api", // 数据固定fix 接口获取api
      autoLoad: "N", //自动加载数据
      dataNum: 6, // 展示的数量
      listStyle: "two",
      show: {
        radius: true, // 是否圆角
        name: true, // 显示商品名字
        price: true, // 显示兑换价格
        stock: true, //库存量
        stop: false, // 到期时间
      },
    },
  },
  //拼团抢购
  groupBuying: {
    icon: { id: 24, type: "groupBuying", name: "拼团抢购", tag: "market" },
    arg: {
      id: [], // 活动信息
      listStyle: "scroll", //list one two three scroll
      space: 10, //页面边距
      lacuna: 10, //商品间距
      show: {
        ratio: "1-1", //图片比例
        border: "", // 无边白底:''，卡片投影:'shadow',描边白底: 'border',无边透明底：'none'
        radius: "", // 直角，圆角-'yes'
        imgFill: "", // 'widthFix'  'aspectFit'
        fontWeight: "normal", // 'normal' bold
        title: true,
        desc: true,
        price: true,
        buy: true,
        shop: "1", // 1,2,3,4,5,6
        shopText: "马上抢",
        origin: true, // 市场价
        stock: true, // 库存
        time: true, // 抢购倒计时
        speed: true, // 抢购进度条
      },
    },
  },
};
export const decAxios = {
  decImgDomain(url, staticImg = "goods.png") {
    //const $decStaticImgUrl = 'https://tikcos.oss-cn-beijing.aliyuncs.com/decOnlineImg/'
    const $decStaticImgUrl = "http://127.0.0.1:8080/static/img/";
    if (url) {
      return url;
    }
    return $decStaticImgUrl + staticImg;
  },
  // 保存微页面
  saveInfo(params) {
    return axios.post("/mock/page/save", params);
  },
  // 获取微页面内容
  getInfo(params) {
    return axios.get("/mock/page/info", {
      params: params,
    });
  },
  // 获取模版页内容
  getTemp(params) {
    return axios.get("/mock/temp/info", {
      params: params,
    });
  },
  // 上传资源
  uploadSource(fileInfo, successCallback, failCallback, save = true) {
    fileInfo.fileCate = sourceMap[fileInfo.fileCate] || "1";
    return axios.post("/mock/resource/upload", fileInfo, {
      processData: false,
      contentType: false,
      async: false,
    });
  },
  // 获取资源
  getSource(params) {
    params.fileCate = sourceMap[params.fileCate] || "1";
    return axios.get("/mock/resource/list", {
      params: { ...params, appCode: "yes" },
    });
  },
  // 获取链接
  getLinkPath() {
    return axios.get("/mock/link/list");
  },
  // 获取链接参数
  getLinkParams(url, params) {
    return axios.get(url, { params: params }).then((res) => {
      // <!-- 支持门店选择、名称筛选｜商品类别 -->
      res.search = {
        tab: {
          key: "shopType",
          name: "商品类别",
          options: [
            {
              value: "111",
              label: "门店1",
            },
          ],
        },
        down: {
          key: "shopId",
          name: "门店选择",
          options: [
            {
              value: "111",
              label: "门店1",
            },
          ],
        },
      };
      return res;
    });
  },
  // 商品分组种类
  getGoodGroup(params) {
    return axios.get("/mock/goodGroup/list", {
      params: params,
    });
  },
  // 商品分组内容
  // @param ids【'1,2,3'】
  getGoodGroupData(params) {
    return axios.get("/mock/goodGroup/list", {
      params: params,
    });
  },
  // 商品列表表格-含有商品分类
  // pageNo: this.current
  // pageSize: 5
  // search: this.search
  // productType: 1百货商家(专柜到家);2全球购(运营);3超市自营(江北门店、西湖门店);4超市一件代;6-O2O商家
  getGoodListTable(params) {
    return axios
      .get("/mock/goodList/list", {
        params: params,
      })
      .then((res) => {
        res.search = {
          tab: {
            key: "productType",
            options: [
              {
                value: "1",
                label: "百货商品",
              },
              {
                value: "2",
                label: "全球购商品",
              },
              {
                value: "3",
                label: "超市商品",
              },
              {
                value: "6",
                label: "O2O商品",
              },
            ],
          },
        };
        return res;
      });
  },
  getImportGoodList(ids) {
    return axios.get("/mock/goodList/list", {
      params: { ids },
    });
  },
  // 商品列表数据
  // @param getType【0-通过获取ids中对应的数据，1-获取一定数量的数据】
  // @param getCount【数据数量标示,默认10】
  // @param ids【'1,2,3'】
  getGoodListData(params) {
    return axios.get("/mock/goodList/list", {
      params: params,
    });
  },
  // 砍价表格
  // pageNo: this.current
  // pageSize: 5
  // search: this.search
  getBargainTable(params) {
    return axios.get("/mock/toBargain/list", {
      params: params,
    });
  },
  // 砍价
  // @param getType【0-通过获取ids中对应的数据，1-获取一定数量的数据】
  // @param getCount【数据数量标示,默认10】
  // @param ids【'1,2,3'】
  getBargainData(params) {
    return axios.get("/mock/toBargain/list", {
      params: params,
    });
  },
  // 拼团表格
  // pageNo: this.current
  // pageSize: 5
  // search: this.search
  getShoppingTable(params) {
    return axios.get("/mock/toShopping/list", {
      params: params,
    });
  },
  // 拼团
  // @param getType【0-通过获取ids中对应的数据，1-获取一定数量的数据】
  // @param getCount【数据数量标示,默认10】
  // @param ids【'1,2,3'】
  // todo: 获取全部数据，前端进行数据分类
  getShoppingData(params) {
    return axios.get("/mock/toShopping/list", {
      params: {
        ...params,
        order: "desc",
        appCode: "yes",
      },
    });
  },
  // 优惠券表格
  // pageNo: this.current
  // pageSize: 5
  getShopCouponTable(params) {
    return axios.get("/mock/shopCoupon/list", {
      params: params,
    });
  },
  // 优惠券
  // @param getType【0-通过获取ids中对应的数据，1-获取一定数量的数据】
  // @param getCount【数据数量标示,默认10】
  // @param ids【'1,2,3'】
  getShopCouponData(params) {
    return axios.get("/mock/shopCoupon/list", {
      params: params,
    });
  },
  // 限时抢购表格
  // pageNo: this.current
  // pageSize: 5
  // search: this.search
  getGoodDiscountTable(params) {
    return axios.get("/mock/goodDiscount/list", {
      params: params,
    });
  },
  // 限时抢购数据-活动详情和活动商品
  // @param id
  getGoodDiscountData(params) {
    return axios.get("/mock/goodDiscount/good", {
      params: {
        ...params,
      },
    });
  },
  // 专区商品活动选择
  getGoodSpecialTable(params) {
    return axios.get("/mock/goodSpecial/list", {
      params: params,
    });
  },
  // 专区商品活动详情
  // @param id
  getGoodSpecialData(params) {
    return axios.get("/mock/goodSpecial/list", {
      params: params,
    });
  },
  // 优惠限购活动选择
  getGoodFineTable(params) {
    return axios.get("/mock/goodFine/list", {
      params: params,
    });
  },
  // 优惠限购活动详情
  // @param id
  getGoodFineData(params) {
    return axios.get("/mock/goodFine/list", {
      params: params,
    });
  },
  // 商家分组列表数据
  // @param ids【'1,2,3'】
  getShopGroup(params) {
    return axios.get("/mock/shopGroup/list", {
      params: params,
    });
  },
  // 商家分组列表数据
  // @param ids【'1,2,3'】
  // @param lon【'1,2,3'】
  // @param lat【'1,2,3'】
  getShopGroupData(params) {
    return axios.get("/mock/shopGroup/list", {
      params: params,
    });
  },
  getGoodIntegralData(params) {
    return axios.get("/mock/goodIntegral/list", {
      params: params,
    });
  },

  getJsonPages(params) {
    return axios.get("/mock/page/list", {
      params: { appCode: "yes", ...params },
    });
  },
  // 保存微页面
  copyJsonPage(params) {
    return axios.post("/mock/page/save", params);
  },
  // 删除微页面
  delJsonPage(params) {
    params.state = 1;
    return axios.delete("/mock/page/delete", { data: params });
  },
  // 设置主页
  setHomePage(params) {
    return axios.post("/mock/page/setHome", params);
  },
  // 模版类型-new Promise(resolve=>resolve({code:201}))
  getTempCates() {
    return axios.post("/mock/temp/type");
  },
  // 模版数据
  getJsonTemps(params) {
    return axios.get("/mock/temp/list", {
      params: { ...params, appCode: "yes" },
    });
  },
  // 设为模版
  setPageToTemp(params) {
    return axios.post("/mock/page/setTemp", params);
  },
};
export default {
  decState,
  decAxios,
};
