import goodModal from "./goodTableModal";
import linkModal from "./tableModal";
import diyLinkModel from "./linkDiyModel";
export default {
  name: "linkBox",
  inject: ["decAxios"],
  components: {
    goodModal,
    linkModal,
    diyLinkModel,
  },
  data() {
    return {
      waiting: false,
      options: [], // 链接下拉框数组
      first: {
        //一级弹框
        h: 0,
        w: 0,
        t: 0,
        l: 0,
      },
      openKey: -1,
      linkArg: {},
      display: "none",
      container: {
        top: 0,
        left: 0,
        right: "",
        padding: "",
      },
    };
  },
  computed: {
    classArg() {
      let arr = ["dec-link-menu"];
      if (this.openKey > -1) arr.push("hassub");
      if (this.container.right) arr.push("isright");
      return arr.join(" ");
    },
  },
  created() {
    this.decAxios.getLinkPath().then((res) => {
      console.log(res, "数据");
      this.options = res.code == 200 ? res.result : [];
    });
  },
  mounted() {
    document.body.appendChild(this.$el);
  },
  beforeDestroy() {
    document.body.removeChild(this.$el);
  },
  methods: {
    //选取链接项时触发下拉框
    show(e, className) {
      let ePath = e.path || (e.composedPath && e.composedPath());
      //定位鼠标点击元素在可视区上的top,left
      let target = ePath[0];

      let { x, y } = e;
      x = e.x - e.offsetX; //鼠标就近目标位置x
      y = e.y - e.offsetY; //鼠标就近目标位置y
      if (className) {
        for (let i = 0; i < ePath.length; i++) {
          const path = ePath[i];
          if ((path.className || "").indexOf(className) > -1) {
            target = path;
            break;
          } else {
            x = x - path.offsetLeft;
            y = y - path.offsetTop;
          }
        }
      }
      //点击元素长宽
      const clientHeight = target.clientHeight;
      const clientWidth = target.clientWidth;
      //调整top,left
      y = y + 2;
      const windowH = document.getElementsByTagName("html")[0].clientHeight; //屏高
      const maxCount = Math.floor((windowH - y - 10) / 32);
      const len =
        this.options.length > maxCount
          ? 0 - this.options.length
          : this.options.length;
      if (len < 0) {
        y = y - 12 + len * 32;
        this.container.padding = `0 0 ${clientHeight}px 0`;
      } else {
        this.container.padding = `${clientHeight}px 0 0 0`;
      }
      //显示赋值
      this.first.t = y;
      this.first.l = x;
      this.container.left = this.first.l + "px";
      this.container.top = this.first.t + "px";
      this.display = "block";
    },
    //离开选择框
    hide(e) {
      if (this.waiting) return;
      this.waiting = false;
      this.first = {
        h: 0,
        w: 0,
        t: 0,
        l: 0,
      };
      this.openKey = -1;
      this.linkArg = {};
      this.display = "none";
      this.container = {
        top: 0,
        left: 0,
        right: "",
        padding: "",
      };
      if (e) this.$emit("promise", { success: false });
    },
    //显示二级目录
    hovor(i) {
      this.openKey = i;
      //重新调整left的值
      if (i > -1) {
        if (this.first.h == 0) {
          const dom = document.querySelectorAll(
            "#declinkBox .dec-link-menu > .dec-menu"
          );
          this.first.h = dom.length > 0 ? dom[0].clientHeight : 0;
          this.first.w = dom.length > 0 ? dom[0].clientWidth : 0;
        }
        const clientWidth =
          document.querySelectorAll("#declinkBox")[0].clientWidth;
        const x = this.first.w * 2 + this.first.l;
        if (x > clientWidth) {
          this.container.left = "";
          this.container.right =
            clientWidth - this.first.l - this.first.w + "px";
        }
      } else if (i == -1) {
        this.container.right = "";
        this.container.left = this.first.l + "px";
      }
    },
    //选中选项
    select(i) {
      if (this.openKey == -1) {
        this.handler(this.options[i]);
      } else {
        this.handler(this.options[this.openKey].childs[i]);
      }
    },
    handler(item) {
      if (item.isOpen == "2") {
        // 打开外链接填写框
        this.linkArg = { pathName: "外链" };
        this.$refs.decDiyLinkMdRef.show();
        this.waiting = true;
        this.$refs.decDiyLinkMdRef.$once("promise", (res) => {
          this.waiting = false;
          if (res.success) {
            this.linkArg = Object.assign({}, this.linkArg, res);
            this.$emit("promise", { ...this.linkArg, success: true });
          } else {
            this.$emit("promise", { success: false });
          }
          this.hide();
        });
      } else if (item.isOpen == "1") {
        // 打开弹窗-含有路由参数
        this.linkArg = {
          pathName: item.urlContent,
          path: item.urlPattern || item.urlType,
        };
        if (item.openUrl) {
          let refName =
            item.urlType == "good-list" ? "decLinkGMdRef" : "decLinkMdRef";
          console.log("item.urlType:", item.urlType, "refName:", refName);
          this.$refs[refName].show({
            moulder: "getLinkParams",
            url: item.openUrl || "",
            column: item.caseName || "",
            type: item.urlType,
          });
          this.waiting = true;
          this.$refs[refName].$once("promise", (res) => {
            this.waiting = false;
            if (res.success) {
              this.linkArg = Object.assign({}, this.linkArg, res);
              this.$emit("promise", { ...this.linkArg, success: true });
            } else {
              this.$emit("promise", { success: false });
            }
            this.hide();
          });
        } else {
          this.$message.error("链接数据不完整");
        }
      } else {
        // 一级链接
        this.linkArg = {
          pathName: item.urlContent,
          path: item.urlPattern || item.urlType,
        };
        this.$emit("promise", { success: true, ...this.linkArg });
        this.hide();
      }
    },
  },
  //一级二级菜单
  render() {
    return (
      <div
        id="declinkBox"
        class="dec-link-box"
        style={{ display: this.display }}
      >
        <div class="wrap" style={this.container} vOn:mouseleave={this.hide}>
          <div class={this.classArg}>
            <ul class="dec-menu">
              {this.options.map((item, i) => {
                return !item.childs ? (
                  <li
                    vOn:mouseenter={() => {
                      this.hovor(-1);
                    }}
                    vOn:click={() => {
                      this.select(i);
                    }}
                  >
                    <a>{item.urlContent}</a>
                  </li>
                ) : (
                  <li class="dec-link-submenu">
                    <a
                      class={this.openKey == i ? "selected" : ""}
                      vOn:mouseenter={() => {
                        this.hovor(i);
                      }}
                    >
                      {item.urlContent}
                      <a-icon type="right" />
                    </a>
                  </li>
                );
              })}
            </ul>
            {this.openKey > -1 ? (
              <ul
                class="sub-menu dec-menu"
                style={{ height: this.first.h + "px" }}
              >
                {this.options[this.openKey].childs.map((child, j) => {
                  return (
                    <li
                      vOn:click={() => {
                        this.select(j);
                      }}
                    >
                      <a>{child.urlContent}</a>
                    </li>
                  );
                })}
              </ul>
            ) : null}
          </div>
        </div>
        <good-modal ref="decLinkGMdRef"></good-modal>
        <link-modal ref="decLinkMdRef"></link-modal>
        <diy-link-model ref="decDiyLinkMdRef"></diy-link-model>
      </div>
    );
  },
};
