var Mock = require("mockjs");
const Random = Mock.Random;
let isDefault = 0;
function getQuery(query) {
  const map = {
    id: "",
    getType: "0",
    ids: "1,2,3,4,5,6",
    getCount: 6,
    pageSize: 0,
    pageNo: 0,
    imgSize: "100x100",
    total: 0,
  };
  return Object.assign({}, map, query);
}
// 商品分组
function goodGroup(req, res) {
  const query = getQuery(req.query);
  // eslint-disable-next-line no-unused-vars
  const ids = (query.ids || "").split(",");
  const len = query.getType == "0" ? ids.length : parseInt(query.getCount);

  let data = [];
  for (let i = 0; i < len; i++) {
    const obj = Mock.mock({
      id: "id" + i,
      groupName: "分组-" + Random.ctitle(1, 2),
      "productInfoList|1-10": [
        {
          id: "item-" + i,
          productImg: Random.image("140x160", "#deabab", "#FFF", "goodGroup"),
          productName: "商品-" + Random.ctitle(1, 10),
          productDesc: "商品描述-" + Random.ctitle(1, 10),
          "productPrice|10-20": Random.integer(),
          "salePrice|1-10": Random.integer(),
          shopName: "店铺名-" + Random.ctitle(1, 4),
        },
      ],
    });
    data.push(obj);
  }

  const haha = Random.image("140x140", "#deabab", "#FFF", "good140");
  data[0].productInfoList[0].productImg = haha;
  res.json({ code: 200, result: data });
}
// 商品列表
function goodList(req, res) {
  const query = getQuery(req.query);
  // eslint-disable-next-line no-unused-vars
  const ids = (query.ids || "").split(",");

  let len = query.getType == "0" ? ids.length : parseInt(query.getCount);
  // eslint-disable-next-line no-unused-vars
  let max = 10;
  // eslint-disable-next-line no-unused-vars
  let min = 0;
  if (parseInt(query.pageSize) > 0) {
    max = parseInt(query.pageNo) > 1 ? 4 : parseInt(query.pageSize);
    min = (parseInt(query.pageNo) - 1) * parseInt(query.pageSize);
    len = max;
  }

  let data = [];
  for (let i = 0; i < len; i++) {
    const obj = Mock.mock({
      id: min + i + 1,
      productImg: Random.image(
        i == 0 ? "140x140" : "140x160",
        "#deabab",
        "#FFF",
        "goodList"
      ),
      productName: "商品名称-" + Random.ctitle(1, 10),
      productDesc: "商品描述-" + Random.ctitle(1, 10),
      "productPrice|50-60": Random.integer(),
      "salePrice|60-100": Random.integer(),
      shopName: "店铺名-" + Random.ctitle(1, 4),
    });
    data.push(obj);
  }
  res.json({
    code: 200,
    result: {
      records: data,
      size: query.pageSize,
      current: query.pageNo,
      total: 100,
    },
  });
}
//优惠券
function shopCoupon(req, res) {
  const query = getQuery(req.query);
  const ids = (query.ids || "").split(",");

  let len = query.getType == "0" ? ids.length : parseInt(query.getCount);
  let max = 10,
    min = 0;
  if (parseInt(query.pageSize) > 0) {
    max = parseInt(query.pageNo) > 1 ? 4 : parseInt(query.pageSize);
    min = (parseInt(query.pageNo) - 1) * parseInt(query.pageSize);
    len = max;
  }

  let data = [];
  for (let i = 0; i < len; i++) {
    const obj = Mock.mock({
      id: min + i + 1,
      ecardName: "满200减20",
      ecardPrice: 20.0,
      ecardCondition: "满减",
      doleStartTime: null,
      doleEndTime:
        new Date().toLocaleDateString().replace("/", "-") + " 23:59:59",
      isCanBuy: null,
    });
    data.push(obj);
  }
  data[data.length - 1] = {
    ...data[data.length - 1],
    ecardName: "通用10元券",
    ecardPrice: 10.0,
    ecardCondition: "无条件",
  };
  res.json({
    code: 200,
    result: {
      records: data,
      size: query.pageSize,
      current: query.pageNo,
      total: 100,
    },
  });
}
//拼团
function toShopping(req, res) {
  const query = getQuery(req.query);
  const ids = (query.ids || "").split(",");

  let len = query.getType == "0" ? ids.length : parseInt(query.getCount);
  let max = 10,
    min = 0;
  if (parseInt(query.pageSize) > 0) {
    max = parseInt(query.pageNo) > 1 ? 4 : parseInt(query.pageSize);
    min = (parseInt(query.pageNo) - 1) * parseInt(query.pageSize);
    len = max;
  }

  let data = [];
  for (let i = 0; i < len; i++) {
    const obj = Mock.mock({
      id: min + i + 1,
      grouponImg: Random.image("140x160", "#deabab", "#FFF", "toShopping"),
      grouponName: "商品名称-" + Random.ctitle(1, 10),
      "grouponPrice|50-60": Random.integer(),
      "salePrice|60-100": Random.integer(),
      "maxLimit|1-6": Random.integer(),
      "grouponNumber|2-6": Random.integer(),
    });
    data.push(obj);
  }
  res.json({
    code: 200,
    result: {
      records: data,
      size: query.pageSize,
      current: query.pageNo,
      total: 100,
    },
  });
}
// 砍价
function toBargain(req, res) {
  const query = getQuery(req.query);
  const ids = (query.ids || "").split(",");

  let len = query.getType == "0" ? ids.length : parseInt(query.getCount);
  let max = 10,
    min = 0;
  if (parseInt(query.pageSize) > 0) {
    max = parseInt(query.pageNo) > 1 ? 4 : parseInt(query.pageSize);
    min = (parseInt(query.pageNo) - 1) * parseInt(query.pageSize);
    len = max;
  }

  let data = [];
  for (let i = 0; i < len; i++) {
    const obj = Mock.mock({
      id: min + i + 1,
      bargainImg: Random.image("140x160", "#deabab", "#FFF", "toBargain"),
      bargainName: "商品名称-" + Random.ctitle(1, 10),
      "stock|1-10": Random.integer(),
      "maxPrice|60-100": Random.integer(),
    });
    data.push(obj);
  }
  res.json({
    code: 200,
    result: {
      records: data,
      size: query.pageSize,
      current: query.pageNo,
      total: 100,
    },
  });
}
// 限时抢购-通过ids获取数据
// 限购时间-limit，销售价格-salePrice，市场价-productPrice
// 商品描述-desc，剩余件数-remain，总件数-total，商品名称-productName
function goodDiscount(req, res) {
  const query = getQuery(req.query);
  // eslint-disable-next-line no-unused-vars
  const ids = (query.ids || "").split(",");
  let len = query.getType == "0" ? ids.length : parseInt(query.getCount);
  let max = 10,
    min = 0;
  if (parseInt(query.pageSize) > 0) {
    max = parseInt(query.pageNo) > 1 ? 4 : parseInt(query.pageSize);
    min = (parseInt(query.pageNo) - 1) * parseInt(query.pageSize);
    len = max;
  }

  let data = [];
  for (let i = 0; i < len; i++) {
    const obj = Mock.mock({
      id: min + i + 1,
      activityName: "活动名称",
      remark: "活动描述",
      activityStartTime: "2022-5-20",
      activityEndTime:
        new Date().toLocaleDateString().replace("/", "-") + " 23:59:59",
      shopType: "3",
      shopId: "1201",
      shopName: "店铺名称",
      buyLimit: "",
      mainImg: "",
      shareImg: "",
      activityStatus: 2,
    });
    data.push(obj);
  }
  if (query.pageNo) {
    res.json({
      code: 200,
      result: {
        records: data,
        size: query.pageSize,
        current: query.pageNo,
        total: 100,
      },
    });
  } else {
    res.json({
      code: 200,
      result: data[0],
    });
  }
}
function goodDiscount2(req, res) {
  const query = getQuery(req.query);
  const ids = (query.ids || "").split(",");
  let _len = query.getType == "0" ? ids.length : parseInt(query.getCount);
  let max = 10,
    _min = 0;
  if (parseInt(query.pageSize) > 0) {
    max = parseInt(query.pageNo) > 1 ? 4 : parseInt(query.pageSize);
    _min = (parseInt(query.pageNo) - 1) * parseInt(query.pageSize);
    _len = max;
  }
  let data = [];
  for (let i = 0; i < 6; i++) {
    const obj = Mock.mock({
      id: i,
      productImg: Random.image(
        i == 0 ? "140x140" : "140x160",
        "#deabab",
        "#FFF",
        "goodList"
      ),
      productName: "商品名称-" + Random.ctitle(1, 10),
      "activityPrice|0-9": Random.integer(),
      "smarketPrice|10-20": Random.integer(),
      mark: "59.99元起?",
      specDesc: "商品描述-" + Random.ctitle(1, 5),
      "saleCount|1-10": Random.integer(),
      "maxLimit|12-20": Random.integer(),
      shopId: "3",
      shopName: "店铺名称",
      "activityStock|12-20": Random.integer(),
    });
    data.push(obj);
  }
  const activity = Mock.mock({
    id: query.id,
    activityName: query.activityName || "活动名称",
    remark: query.remark || "活动描述",
    activityStartTime: query.activityStartTime || "2022-5-20",
    activityEndTime:
      query.activityEndTime ||
      new Date().toLocaleDateString().replace("/", "-") + " 23:59:59",
    shopType: "3",
    shopId: "1201",
    shopName: "店铺名称",
    buyLimit: "",
    mainImg: "",
    shareImg: "",
    activityStatus: 2,
  });
  res.json({
    code: 200,
    result: {
      activity: activity,
      records: data,
    },
  });
}
// 商家列表数据
function shopGroup(req, res) {
  const query = getQuery(req.query);
  const ids = (query.ids || "").split(",");

  let len = query.getType == "0" ? ids.length : parseInt(query.getCount);
  let max = 10,
    _min = 0;
  if (parseInt(query.pageSize) > 0) {
    max = parseInt(query.pageNo) > 1 ? 4 : parseInt(query.pageSize);
    _min = (parseInt(query.pageNo) - 1) * parseInt(query.pageSize);
    len = max;
  }
  let data = [];
  for (let i = 0; i < len; i++) {
    const obj = Mock.mock({
      id: "分组" + i,
      groupName: "名称-" + i,
      desc: "分组描述",
      shopList: [1, 2, 3, 4].map((key) => {
        return {
          id: key,
          shopLogo: Random.image("140x140", "#deabab", "#FFF", "logo"),
          shopName: "商家名称-" + Random.ctitle(1, 3),
          goodComment: 4.5,
          complateCount: 97,
          discount: "17",
          message: "10分钟前有人消费",
          mark: "面包蛋糕",
          postion: "龙华", // address
          address: "800m", // shopLat: 22.648431 shopLon: 114.027748
          tagName: "520蛋糕,可用消费券,收录6年",
          goods: [
            {
              type: "1",
              name: ["2-3人餐168元起", "4-5人餐288元"],
            },
            {
              type: "2",
              name: ["88代100元", "12代50元"],
            },
          ],
        };
      }),
    });
    data.push(obj);
  }
  res.json({
    code: 200,
    result: {
      records: data,
      size: query.pageSize,
      current: query.pageNo,
      total: 100,
    },
  });
}
// 专区商品
function goodSpecial(req, res) {
  const query = getQuery(req.query);
  const ids = (query.ids || "").split(",");

  let len = query.getType == "0" ? ids.length : parseInt(query.getCount);
  let max = 10,
    _min = 0;
  if (parseInt(query.pageSize) > 0) {
    max = parseInt(query.pageNo) > 1 ? 4 : parseInt(query.pageSize);
    _min = (parseInt(query.pageNo) - 1) * parseInt(query.pageSize);
    len = max;
  }

  let data = [];
  for (let i = 0; i < len; i++) {
    const obj = Mock.mock({
      id: "kkk" + i,
      shopId: "店铺id",
      shopName: "所属店铺",
      zoneName: "专区名称-" + Random.ctitle(1, 3),
      picture: Random.image("375x120", "#deabab", "#FFF", "special img"),
    });
    data.push(obj);
  }
  if (!query.id) {
    res.json({
      code: 200,
      result: {
        records: data,
        size: query.pageSize,
        current: query.pageNo,
        total: 100,
      },
    });
  } else {
    res.json({
      code: 200,
      result: data[0],
    });
  }
}
// 优惠限购
function goodFine(req, res) {
  const query = getQuery(req.query);
  const ids = (query.ids || "").split(",");

  let len = query.getType == "0" ? ids.length : parseInt(query.getCount);
  let max = 10,
    _min = 0;
  if (parseInt(query.pageSize) > 0) {
    max = parseInt(query.pageNo) > 1 ? 4 : parseInt(query.pageSize);
    _min = (parseInt(query.pageNo) - 1) * parseInt(query.pageSize);
    len = max;
  }

  let data = [];
  for (let i = 0; i < len; i++) {
    const obj = Mock.mock({
      id: "kkk" + i,
      shopId: "店铺id",
      shopName: "所属店铺",
      activityName: "活动名称-" + Random.ctitle(1, 3),
      picture: Random.image("375x120", "#deabab", "#FFF", "fine img"),
      startTime: "2022-05-20 23:59:59",
      endTime: new Date().toLocaleDateString().replace("/", "-") + " 23:59:59",
    });
    data.push(obj);
  }
  if (!query.id) {
    res.json({
      code: 200,
      result: {
        records: data,
        size: query.pageSize,
        current: query.pageNo,
        total: 100,
      },
    });
  } else {
    res.json({
      code: 200,
      result: data[0],
    });
  }
}
// 积分商品
function goodIntegral(req, res) {
  const query = getQuery(req.query);
  const ids = (query.ids || "").split(",");

  let len = query.getType == "0" ? ids.length : parseInt(query.getCount);
  let max = 10,
    min = 0;
  if (parseInt(query.pageSize) > 0) {
    max = parseInt(query.pageNo) > 1 ? 4 : parseInt(query.pageSize);
    min = (parseInt(query.pageNo) - 1) * parseInt(query.pageSize);
    len = max;
  }
  let data = [];
  for (let i = 0; i < len; i++) {
    const obj = Mock.mock({
      id: min + i + 1,
      targetImg: Random.image(
        i == 0 ? "140x140" : "140x160",
        "#deabab",
        "#FFF",
        "integral"
      ),
      targetName: "5元超市无门槛券-" + Random.ctitle(1, 10),
      "integral|50-60": Random.integer(),
      "paymentAmount|0-9": Random.integer(),
      stock: 10,
      endTime: "2020-09-08",
    });
    data.push(obj);
  }
  if (!query.id) {
    res.json({
      code: 200,
      result: {
        records: data,
        size: query.pageSize,
        current: query.pageNo,
        total: 100,
      },
    });
  } else {
    res.json({
      code: 200,
      result: data[0],
    });
  }
}
const mock = function (app) {
  // 微页面数据
  app.get("/mock/page/list", function (req, res) {
    const query = getQuery(req.query);
    // eslint-disable-next-line no-unused-vars
    const max = parseInt(query.pageNo) > 1 ? 4 : parseInt(query.pageSize);
    // eslint-disable-next-line no-unused-vars
    const min = (parseInt(query.pageNo) - 1) * parseInt(query.pageSize);
    let data = [];
    for (let i = 0; i < max; i++) {
      const obj = Mock.mock({
        id: `${min + i + 1}`, // Random.integer(),
        pageName: "页面名称-" + Random.ctitle(1, 10),
        pageDesc: Random.cparagraph(0, 3),
        bgcolor: Random.color(),
        pageLayout: "",
        pageCover: Random.image("140x210", "#deabab", "#FFF", "img"),
        isDefault: min + i === isDefault ? 1 : 0,
        "state|1": [-1, 0],
        "visitCount|0-10000": 3,
        createTime: Random.datetime(),
      });
      data.push(obj);
    }

    res.json({
      code: 200,
      result: {
        records: data,
        size: query.pageSize,
        current: query.pageNo,
        total: 20,
        pages: Math.ceil(20 / query.pageSize),
      },
    });
  });
  // 模版类型
  app.post("/mock/temp/type", function (req, res) {
    let arr = ["全部", "基础模板", "主页模板", "场景模板"];
    res.json({
      code: 200,
      result: arr.map((key, index) => {
        return {
          id: index + 1,
          cateName: key,
          cateIcon: null,
          parentId: 0,
          createTime: "2018-07-05",
          updateTime: "2021-07-25",
        };
      }),
    });
  });
  // 模版数据
  app.get("/mock/temp/list", function (req, res) {
    const query = getQuery(req.query);
    const total = 0;
    // eslint-disable-next-line no-unused-vars
    const max = parseInt(query.pageNo) > 1 ? 4 : parseInt(query.pageSize);
    let data = [];
    res.json({
      code: 200,
      result: {
        records: data,
        size: query.pageSize,
        current: query.pageNo,
        total: total,
      },
    });
  });
  // 删除微页面
  app.delete("/mock/page/delete", function (req, res) {
    res.json({
      code: 200,
    });
  });
  // 设置主页
  app.post("/mock/page/setHome", function (req, res) {
    const query = getQuery(req.query);
    isDefault = parseInt(query.id);
    res.json({
      code: 200,
    });
  });
  // 设为模版
  app.post("/mock/page/setTemp", function (req, res) {
    const query = getQuery(req.query);
    isDefault = parseInt(query.id);
    res.json({
      code: 200,
    });
  });
  // 保存微页面
  app.post("/mock/page/save", function (req, res) {
    const query = getQuery(req.query);
    isDefault = parseInt(query.id);
    res.json({
      code: 200,
    });
  });
  // 获取微页面内容-getMicroPageById-getHomePage
  app.get("/mock/page/info", function (req, res) {
    const query = getQuery(req.query);
    isDefault = parseInt(query.id);
    res.json({
      code: 200,
      result: {
        id: "1823167299339513857",
        pageType: "2",
        pageName: "湖畔超市主页",
        pageDesc: "在家逛超市 三公里包邮",
        bgcolor: null,
        pageLayout:
          "%5B%7B%22id%22%3A%22pageSet%22%2C%22type%22%3A%22pageSet%22%2C%22name%22%3A%22%u9875%u9762%u914D%u7F6E%22%2C%22pageName%22%3A%22%u8D85%u5E02%u5230%u5BB6%22%2C%22pageDesc%22%3A%22%u5728%u5BB6%u901B%u8D85%u5E02%20%u4E09%u516C%u91CC%u5305%u90AE%22%2C%22bgImg%22%3A%22%22%2C%22bgImgW%22%3A100%2C%22bgColor%22%3A%22%22%2C%22repeat%22%3Afalse%2C%22fix%22%3Atrue%7D%2C%7B%22id%22%3A%22shopBase%22%2C%22type%22%3A%22shopBase%22%2C%22name%22%3A%22%u9876%u90E8%u5BFC%u822A%22%2C%22mode%22%3A%22custom%22%2C%22styleArg%22%3A%22%22%2C%22fontColor%22%3A%22black%22%2C%22lIcon%22%3A%22back%22%2C%22lIconImg%22%3A%22%22%2C%22lIconLink%22%3A%7B%7D%2C%22title%22%3A%22text%22%2C%22search%22%3Afalse%2C%22searchBg%22%3A%22%23f7f8ff%22%2C%22rIcon%22%3Afalse%2C%22rIconFn%22%3A%5B%5D%2C%22rIconImg%22%3A%22%22%2C%22rIconCc%22%3Atrue%2C%22rIconLink%22%3A%7B%7D%2C%22hide%22%3Afalse%7D%2C%7B%22id%22%3A1660810652875%2C%22name%22%3A%22%u5E7F%u544A%u6A21%u5757%22%2C%22type%22%3A%22imageLink%22%2C%22arg%22%3A%7B%22styleArg%22%3A%22carousel%22%2C%22rowNum%22%3A%221%22%2C%22margin%22%3A%22no%22%2C%22isBackground%22%3Afalse%2C%22radius%22%3Atrue%2C%22space%22%3A0%2C%22lacuna%22%3A0%2C%22ids%22%3A%5B%7B%22img%22%3A%22https%3A//cdn.lirimall.com//lirigo/filetempImage/__20250925145020_922_93_1759227819695.jpg%22%2C%22title%22%3A%22%22%2C%22linkArg%22%3A%7B%22pathName%22%3A%22%u8D85%u5E02%u4E13%u533A%22%2C%22path%22%3A%22/lirisubPages/activity/special%22%2C%22success%22%3Atrue%2C%22argKey%22%3A%22id%22%2C%22argValue%22%3A%221971387914763665410%22%2C%22argParams%22%3A%22id%3D1971387914763665410%22%2C%22argName%22%3A%22%u60E0%u52A8%u56FD%u5E86%u5468%22%7D%7D%2C%7B%22img%22%3A%22https%3A//cdn.lirimall.com//lirigo/filetempImage/8225f87d9940a03566d32058b51dd8d_1745391668344.jpg%22%2C%22title%22%3A%22%22%2C%22linkArg%22%3A%7B%22pathName%22%3A%22%u8D85%u5E02%u4E13%u533A%22%2C%22path%22%3A%22/lirisubPages/activity/special%22%2C%22success%22%3Atrue%2C%22argKey%22%3A%22id%22%2C%22argValue%22%3A%221843571425885892610%22%2C%22argParams%22%3A%22id%3D1843571425885892610%22%2C%22argName%22%3A%22%u4E3D%u65E5%u4F18%u9009%22%7D%7D%2C%7B%22img%22%3A%22https%3A//cdn.lirimall.com//lirigo/filetempImage/ff5153c5b088e6ce9d12a116049aba2_1723192625217.jpg%22%2C%22title%22%3A%22%22%2C%22linkArg%22%3A%7B%22success%22%3Atrue%2C%22pathName%22%3A%22%u62FC%u56E2%u62A2%u8D2D%22%2C%22path%22%3A%22/lirisubPages/activity/shopping%22%7D%7D%2C%7B%22img%22%3A%22https%3A//cdn.lirimall.com//lirigo/filetempImage/53aa8431e0dffafd3667a255cab81e5_1730433340295.jpg%22%2C%22title%22%3A%22%22%2C%22linkArg%22%3A%7B%22pathName%22%3A%22%u8D85%u5E02%u4E13%u533A%22%2C%22path%22%3A%22/lirisubPages/activity/special%22%2C%22success%22%3Atrue%2C%22argKey%22%3A%22id%22%2C%22argValue%22%3A%221723594579229974529%22%2C%22argParams%22%3A%22id%3D1723594579229974529%22%2C%22argName%22%3A%22%u5976%u7C89%u6574%u4EF6%u51CF120%22%7D%7D%2C%7B%22img%22%3A%22https%3A//cdn.lirimall.com//lirigo/filetempImage/644315ed3234b0acc3f80452b9b29e6_1747302331760.jpg%22%2C%22title%22%3A%22%22%2C%22linkArg%22%3A%7B%22pathName%22%3A%22%u8D85%u5E02%u4E13%u533A%22%2C%22path%22%3A%22/lirisubPages/activity/special%22%2C%22success%22%3Atrue%2C%22argKey%22%3A%22id%22%2C%22argValue%22%3A%221922948918284115970%22%2C%22argParams%22%3A%22id%3D1922948918284115970%22%2C%22argName%22%3A%22%u4ECA%u65E5%u63A8%u8350%22%7D%7D%5D%2C%22taps%22%3A%5B%5D%7D%7D%2C%7B%22id%22%3A1660897820390%2C%22name%22%3A%22%u56FE%u5757%22%2C%22type%22%3A%22imageBlock%22%2C%22arg%22%3A%7B%22img%22%3A%22https%3A//cdn.lirimall.com//lirigo/filetempImage/__1695886194305.png%22%2C%22feedId%22%3Anull%2C%22finderUserNameId%22%3Anull%2C%22IsRelevance%22%3Afalse%2C%22lsActivity%22%3A%22no%22%7D%7D%2C%7B%22id%22%3A1673402993756%2C%22name%22%3A%22%u56FE%u6587%u5BFC%u822A%22%2C%22type%22%3A%22shopNav%22%2C%22arg%22%3A%7B%22styleArg%22%3A%22group%22%2C%22rowNum%22%3A5%2C%22iconStyle%22%3A%22top%22%2C%22iconSize%22%3A60%2C%22bgColor%22%3A%22transparent%22%2C%22space%22%3A10%2C%22color%22%3A%22%23000%22%2C%22ids%22%3A%5B%7B%22img%22%3A%22https%3A//cdn.lirimall.com//lirigo/filetempImage/__1673313574382.png%22%2C%22title%22%3A%22%u65F6%u4EE4%u852C%u83DC%22%2C%22linkArg%22%3A%7B%22pathName%22%3A%22%u8D85%u5E02%u5206%u7C7B%22%2C%22path%22%3A%22/lirisubPages/supermarket/class%22%2C%22success%22%3Atrue%2C%22argKey%22%3A%22id%22%2C%22argValue%22%3A%221719958285861654610%22%2C%22argParams%22%3A%22id%3D1719958285861654610%26pid%3D0%22%2C%22argName%22%3A%22%u65F6%u4EE4%u852C%u83DC%22%7D%7D%2C%7B%22img%22%3A%22https%3A//cdn.lirimall.com//lirigo/filetempImage/__1673313604843.png%22%2C%22title%22%3A%22%u65B0%u9C9C%u8089%u86CB%22%2C%22linkArg%22%3A%7B%22pathName%22%3A%22%u8D85%u5E02%u5206%u7C7B%22%2C%22path%22%3A%22/lirisubPages/supermarket/class%22%2C%22success%22%3Atrue%2C%22argKey%22%3A%22id%22%2C%22argValue%22%3A%221719958285970456583%22%2C%22argParams%22%3A%22id%3D1719958285970456583%26pid%3D0%22%2C%22argName%22%3A%22%u65B0%u9C9C%u8089%u86CB%22%7D%7D%2C%7B%22img%22%3A%22https%3A//cdn.lirimall.com//lirigo/filetempImage/__1673313592630.png%22%2C%22title%22%3A%22%u65B0%u9C9C%u6C34%u679C%22%2C%22linkArg%22%3A%7B%22pathName%22%3A%22%u8D85%u5E02%u5206%u7C7B%22%2C%22path%22%3A%22/lirisubPages/supermarket/class%22%2C%22success%22%3Atrue%2C%22argKey%22%3A%22id%22%2C%22argValue%22%3A%221719958285928550424%22%2C%22argParams%22%3A%22id%3D1719958285928550424%26pid%3D0%22%2C%22argName%22%3A%22%u65B0%u9C9C%u6C34%u679C%22%7D%7D%2C%7B%22img%22%3A%22https%3A//cdn.lirimall.com//lirigo/filetempImage/__1673313628976.png%22%2C%22title%22%3A%22%u6C34%u4EA7%u6D77%u9C9C%22%2C%22linkArg%22%3A%7B%22pathName%22%3A%22%u8D85%u5E02%u5206%u7C7B%22%2C%22path%22%3A%22/lirisubPages/supermarket/class%22%2C%22success%22%3Atrue%2C%22argKey%22%3A%22id%22%2C%22argValue%22%3A%221719958286066831368%22%2C%22argParams%22%3A%22id%3D1719958286066831368%26pid%3D0%22%2C%22argName%22%3A%22%u6C34%u4EA7%u6D77%u9C9C%22%7D%7D%2C%7B%22img%22%3A%22https%3A//cdn.lirimall.com//lirigo/filetempImage/__1673313719833.png%22%2C%22title%22%3A%22%u4F11%u95F2%u96F6%u98DF%22%2C%22linkArg%22%3A%7B%22pathName%22%3A%22%u8D85%u5E02%u5206%u7C7B%22%2C%22path%22%3A%22/lirisubPages/supermarket/class%22%2C%22success%22%3Atrue%2C%22argKey%22%3A%22id%22%2C%22argValue%22%3A%221719958286230536218%22%2C%22argParams%22%3A%22id%3D1719958286230536218%26pid%3D0%22%2C%22argName%22%3A%22%u5E74%u8D27%u7206%u6B3E%22%7D%7D%2C%7B%22img%22%3A%22https%3A//cdn.lirimall.com//lirigo/filetempImage/__1673323403261.png%22%2C%22title%22%3A%22%u7EB8%u54C1%u5BB6%u6E05%22%2C%22linkArg%22%3A%7B%22pathName%22%3A%22%u8D85%u5E02%u5206%u7C7B%22%2C%22path%22%3A%22/lirisubPages/supermarket/class%22%2C%22success%22%3Atrue%2C%22argKey%22%3A%22id%22%2C%22argValue%22%3A%221719958286478016552%22%2C%22argParams%22%3A%22id%3D1719958286478016552%26pid%3D0%22%2C%22argName%22%3A%22%u7EB8%u54C1%u5BB6%u6E05%22%7D%7D%2C%7B%22img%22%3A%22https%3A//cdn.lirimall.com//lirigo/filetempImage/__1673401907456.png%22%2C%22title%22%3A%22%u4E73%u54C1%u70D8%u7119%22%2C%22linkArg%22%3A%7B%22pathName%22%3A%22%u8D85%u5E02%u5206%u7C7B%22%2C%22path%22%3A%22/lirisubPages/supermarket/class%22%2C%22success%22%3Atrue%2C%22argKey%22%3A%22id%22%2C%22argValue%22%3A%221719958286117363759%22%2C%22argParams%22%3A%22id%3D1719958286117363759%26pid%3D0%22%2C%22argName%22%3A%22%u4E73%u54C1%u70D8%u7119%22%7D%7D%2C%7B%22img%22%3A%22https%3A//cdn.lirimall.com//lirigo/filetempImage/__1673401934296.png%22%2C%22title%22%3A%22%u7CAE%u6CB9%u7C73%u9762%22%2C%22linkArg%22%3A%7B%22pathName%22%3A%22%u8D85%u5E02%u5206%u7C7B%22%2C%22path%22%3A%22/lirisubPages/supermarket/class%22%2C%22success%22%3Atrue%2C%22argKey%22%3A%22id%22%2C%22argValue%22%3A%221719958286180274241%22%2C%22argParams%22%3A%22id%3D1719958286180274241%26pid%3D0%22%2C%22argName%22%3A%22%u7CAE%u6CB9%u7C73%u9762%22%7D%7D%2C%7B%22img%22%3A%22https%3A//cdn.lirimall.com//lirigo/filetempImage/__1673401969078.png%22%2C%22title%22%3A%22%u996E%u6599%u51B2%u8C03%22%2C%22linkArg%22%3A%7B%22pathName%22%3A%22%u8D85%u5E02%u5206%u7C7B%22%2C%22path%22%3A%22/lirisubPages/supermarket/class%22%2C%22success%22%3Atrue%2C%22argKey%22%3A%22id%22%2C%22argValue%22%3A%221719958286276751434%22%2C%22argParams%22%3A%22id%3D1719958286276751434%26pid%3D0%22%2C%22argName%22%3A%22%u996E%u6599%u51B2%u8C03%22%7D%7D%2C%7B%22img%22%3A%22https%3A//cdn.lirimall.com//lirigo/filetempImage/__1673401829068.png%22%2C%22title%22%3A%22%u51B7%u85CF%u51B7%u51BB%22%2C%22linkArg%22%3A%7B%22pathName%22%3A%22%u8D85%u5E02%u5206%u7C7B%22%2C%22path%22%3A%22/lirisubPages/supermarket/class%22%2C%22success%22%3Atrue%2C%22argKey%22%3A%22id%22%2C%22argValue%22%3A%221719958286012665918%22%2C%22argParams%22%3A%22id%3D1719958286012665918%26pid%3D0%22%2C%22argName%22%3A%22%u51B7%u85CF%u51B7%u51BB%22%7D%7D%5D%7D%7D%2C%7B%22id%22%3A1710468887000%2C%22name%22%3A%22%u5E7F%u544A%u6A21%u5757%22%2C%22type%22%3A%22imageLink%22%2C%22arg%22%3A%7B%22styleArg%22%3A%22carousel%22%2C%22rowNum%22%3A%221%22%2C%22margin%22%3A%22no%22%2C%22isBackground%22%3Afalse%2C%22radius%22%3Atrue%2C%22space%22%3A0%2C%22lacuna%22%3A0%2C%22ids%22%3A%5B%7B%22img%22%3A%22https%3A//cdn.lirimall.com//lirigo/filetempImage/__20250903170015_418_93_1756892112440.png%22%2C%22title%22%3A%22%22%2C%22linkArg%22%3A%7B%22pathName%22%3A%22%u8D85%u5E02%u4E13%u533A%22%2C%22path%22%3A%22/lirisubPages/activity/special%22%2C%22success%22%3Atrue%2C%22argKey%22%3A%22id%22%2C%22argValue%22%3A%221891754318446071810%22%2C%22argParams%22%3A%22id%3D1891754318446071810%22%2C%22argName%22%3A%22%u54C1%u724C%u6D3B%u52A8%u6EE1%u51CF%22%7D%7D%2C%7B%22img%22%3A%22https%3A//cdn.lirimall.com//lirigo/filetempImage/__20250903171159_419_93_1756892018170.png%22%2C%22title%22%3A%22%22%2C%22linkArg%22%3A%7B%22pathName%22%3A%22%u8D85%u5E02%u4E13%u533A%22%2C%22path%22%3A%22/lirisubPages/activity/special%22%2C%22success%22%3Atrue%2C%22argKey%22%3A%22id%22%2C%22argValue%22%3A%221960867942447611906%22%2C%22argParams%22%3A%22id%3D1960867942447611906%22%2C%22argName%22%3A%22%u8FDB%u53E3%u4E13%u533A%22%7D%7D%2C%7B%22img%22%3A%22https%3A//cdn.lirimall.com//lirigo/filetempImage/__20250903171200_421_93_1756892037600.png%22%2C%22title%22%3A%22%22%2C%22linkArg%22%3A%7B%22pathName%22%3A%22%u8D85%u5E02%u4E13%u533A%22%2C%22path%22%3A%22/lirisubPages/activity/special%22%2C%22success%22%3Atrue%2C%22argKey%22%3A%22id%22%2C%22argValue%22%3A%221960647166783217666%22%2C%22argParams%22%3A%22id%3D1960647166783217666%22%2C%22argName%22%3A%22%u6ECB%u8865%u517B%u751F%u4E13%u533A%22%7D%7D%2C%7B%22img%22%3A%22https%3A//cdn.lirimall.com//lirigo/filetempImage/__20250903171159_420_93_1756892101473.png%22%2C%22title%22%3A%22%22%2C%22linkArg%22%3A%7B%22pathName%22%3A%22%u8D85%u5E02%u4E13%u533A%22%2C%22path%22%3A%22/lirisubPages/activity/special%22%2C%22success%22%3Atrue%2C%22argKey%22%3A%22id%22%2C%22argValue%22%3A%221951932690480160770%22%2C%22argParams%22%3A%22id%3D1951932690480160770%22%2C%22argName%22%3A%22%u590F%u5B63%u9632%u868A%u63A8%u8350%22%7D%7D%5D%2C%22taps%22%3A%5B%5D%7D%7D%2C%7B%22id%22%3A1688641118214%2C%22name%22%3A%22%u5E7F%u544A%u6A21%u5757%22%2C%22type%22%3A%22imageLink%22%2C%22arg%22%3A%7B%22styleArg%22%3A%22tap%22%2C%22rowNum%22%3A%221%22%2C%22margin%22%3A%22no%22%2C%22isBackground%22%3Afalse%2C%22radius%22%3Atrue%2C%22space%22%3A0%2C%22lacuna%22%3A0%2C%22ids%22%3A%5B%7B%22img%22%3A%22https%3A//cdn.lirimall.com//lirigo/filetempImage/yasuo_1756721663030.png%22%2C%22title%22%3A%22%22%2C%22linkArg%22%3A%7B%7D%7D%5D%2C%22taps%22%3A%5B%7B%22top%22%3A%2248.37%25%22%2C%22left%22%3A%221.92%25%22%2C%22width%22%3A%2247.96%25%22%2C%22height%22%3A%2249.47%25%22%2C%22linkArg%22%3A%7B%22pathName%22%3A%22%u8D85%u5E02%u4E13%u533A%22%2C%22path%22%3A%22/lirisubPages/activity/special%22%2C%22success%22%3Atrue%2C%22argKey%22%3A%22id%22%2C%22argValue%22%3A%221962451265845481474%22%2C%22argParams%22%3A%22id%3D1962451265845481474%22%2C%22argName%22%3A%22%u6C34%u679C%u793C%u76D2%22%7D%7D%2C%7B%22top%22%3A%221.4%25%22%2C%22left%22%3A%2250.75%25%22%2C%22width%22%3A%2248.75%25%22%2C%22height%22%3A%2245.79%25%22%2C%22linkArg%22%3A%7B%22pathName%22%3A%22%u8D85%u5E02%u4E13%u533A%22%2C%22path%22%3A%22/lirisubPages/activity/special%22%2C%22success%22%3Atrue%2C%22argKey%22%3A%22id%22%2C%22argValue%22%3A%221962450387089481730%22%2C%22argParams%22%3A%22id%3D1962450387089481730%22%2C%22argName%22%3A%22%u6ECB%u8865%u5E72%u8D27%22%7D%7D%2C%7B%22top%22%3A%2248.18%25%22%2C%22left%22%3A%2250.35%25%22%2C%22width%22%3A%2248.64%25%22%2C%22height%22%3A%2249.53%25%22%2C%22linkArg%22%3A%7B%22pathName%22%3A%22%u8D85%u5E02%u4E13%u533A%22%2C%22path%22%3A%22/lirisubPages/activity/special%22%2C%22success%22%3Atrue%2C%22argKey%22%3A%22id%22%2C%22argValue%22%3A%221962456621402284034%22%2C%22argParams%22%3A%22id%3D1962456621402284034%22%2C%22argName%22%3A%22%u9187%u9999%u4E73%u54C1%22%7D%7D%2C%7B%22top%22%3A%221.38%25%22%2C%22left%22%3A%221.98%25%22%2C%22width%22%3A%2248.06%25%22%2C%22height%22%3A%2246.27%25%22%2C%22linkArg%22%3A%7B%22pathName%22%3A%22%u8D85%u5E02%u4E13%u533A%22%2C%22path%22%3A%22/lirisubPages/activity/special%22%2C%22success%22%3Atrue%2C%22argKey%22%3A%22id%22%2C%22argValue%22%3A%221962449597331398658%22%2C%22argParams%22%3A%22id%3D1962449597331398658%22%2C%22argName%22%3A%22%u9AD8%u7AEF%u9152%u996E%22%7D%7D%5D%7D%7D%2C%7B%22id%22%3A1710468901327%2C%22name%22%3A%22%u5546%u54C1%u5217%u8868%22%2C%22type%22%3A%22goodList%22%2C%22arg%22%3A%7B%22static%22%3Afalse%2C%22import%22%3Atrue%2C%22styleArg%22%3A%22fix%22%2C%22concat%22%3Atrue%2C%22autoLoad%22%3A%22N%22%2C%22dataNum%22%3A6%2C%22ids%22%3A%5B%223@133608%22%2C%223@133760%22%2C%223@94521%22%2C%223@101414%22%2C%223@133749%22%2C%223@30536%22%2C%223@133846%22%2C%223@126679%22%2C%223@129033%22%2C%223@133839%22%2C%223@35699%22%2C%223@126677%22%2C%223@85532%22%2C%223@106018%22%2C%223@111441%22%2C%223@35569%22%2C%223@42107%22%2C%223@46671%22%2C%223@85532%22%2C%223@16921%22%2C%223@30540%22%2C%223@58388%22%2C%223@92428%22%2C%223@20597%22%2C%223@26317%22%5D%2C%22listStyle%22%3A%22scroll-three%22%2C%22layout%22%3A%22%22%2C%22show%22%3A%7B%22border%22%3A%22%22%2C%22radius%22%3Atrue%2C%22name%22%3Atrue%2C%22nameStyle%22%3A%22%22%2C%22price%22%3Atrue%2C%22origin%22%3Afalse%2C%22bug%22%3Atrue%2C%22bugStyle%22%3A%22custom%22%2C%22bugTxt%22%3A%22%u8D2D%u4E70%22%2C%22mark%22%3Afalse%2C%22markStyle%22%3A%22%22%2C%22desc%22%3Afalse%2C%22descTxt%22%3A%22%22%2C%22shopName%22%3Afalse%2C%22postType%22%3Afalse%2C%22reward%22%3Afalse%7D%2C%22isWheelSeed%22%3Atrue%7D%7D%2C%7B%22id%22%3A1747385062899%2C%22name%22%3A%22%u5546%u54C1%u5217%u8868%22%2C%22type%22%3A%22goodList%22%2C%22arg%22%3A%7B%22static%22%3Afalse%2C%22import%22%3Atrue%2C%22styleArg%22%3A%22fix%22%2C%22concat%22%3Atrue%2C%22autoLoad%22%3A%22N%22%2C%22dataNum%22%3A6%2C%22ids%22%3A%5B%223@133845%22%2C%223@133842%22%2C%223@133843%22%2C%223@133839%22%2C%223@133841%22%2C%223@133840%22%2C%223@133844%22%2C%223@130808%22%2C%223@130807%22%2C%223@130809%22%2C%223@121540%22%2C%223@123440%22%2C%223@117449%22%2C%223@1942%22%2C%223@20567%22%2C%223@20625%22%2C%223@101398%22%2C%223@23245%22%2C%223@70840%22%2C%223@83702%22%2C%223@91130%22%2C%223@92428%22%2C%223@92429%22%2C%223@20615%22%2C%223@101402%22%2C%223@20597%22%2C%223@101332%22%2C%223@20593%22%5D%2C%22listStyle%22%3A%22scroll-three%22%2C%22layout%22%3A%22%22%2C%22show%22%3A%7B%22border%22%3A%22%22%2C%22radius%22%3Atrue%2C%22name%22%3Atrue%2C%22nameStyle%22%3A%22%22%2C%22price%22%3Atrue%2C%22origin%22%3Atrue%2C%22bug%22%3Afalse%2C%22bugStyle%22%3A%22plus%22%2C%22bugTxt%22%3A%22%22%2C%22mark%22%3Afalse%2C%22markStyle%22%3A%22%22%2C%22desc%22%3Atrue%2C%22descTxt%22%3A%22%22%2C%22shopName%22%3Afalse%2C%22postType%22%3Afalse%2C%22reward%22%3Afalse%7D%7D%7D%2C%7B%22id%22%3A1710469125053%2C%22name%22%3A%22%u5E7F%u544A%u6A21%u5757%22%2C%22type%22%3A%22imageLink%22%2C%22arg%22%3A%7B%22styleArg%22%3A%22tap%22%2C%22rowNum%22%3A%221%22%2C%22margin%22%3A%22no%22%2C%22isBackground%22%3Afalse%2C%22radius%22%3Atrue%2C%22space%22%3A0%2C%22lacuna%22%3A0%2C%22ids%22%3A%5B%7B%22img%22%3A%22https%3A//cdn.lirimall.com//lirigo/filetempImage/5fdd0dd48e2a024b71d539d55ee2236_1710468437805.png%22%2C%22title%22%3A%22%22%2C%22linkArg%22%3A%7B%7D%7D%5D%2C%22taps%22%3A%5B%7B%22top%22%3A%22-18.84%25%22%2C%22left%22%3A%220%25%22%2C%22width%22%3A%2220%25%22%2C%22height%22%3A%22118.09%25%22%2C%22linkArg%22%3A%7B%22pathName%22%3A%22%u8D85%u5E02%u4E13%u533A%22%2C%22path%22%3A%22/lirisubPages/activity/special%22%2C%22success%22%3Atrue%2C%22argKey%22%3A%22id%22%2C%22argValue%22%3A%221765177448350953473%22%2C%22argParams%22%3A%22id%3D1765177448350953473%22%2C%22argName%22%3A%22%u4ECA%u65E5%u63A8%u8350%22%7D%7D%2C%7B%22top%22%3A%22-18.13%25%22%2C%22left%22%3A%2280%25%22%2C%22width%22%3A%2220%25%22%2C%22height%22%3A%22118.09%25%22%2C%22linkArg%22%3A%7B%22success%22%3Atrue%2C%22pathName%22%3A%22%u62FC%u56E2%u62A2%u8D2D%22%2C%22path%22%3A%22/lirisubPages/activity/shopping%22%7D%7D%2C%7B%22top%22%3A%22-18.84%25%22%2C%22left%22%3A%2253%25%22%2C%22width%22%3A%2220%25%22%2C%22height%22%3A%22118.09%25%22%2C%22linkArg%22%3A%7B%22pathName%22%3A%22%u8D85%u5E02%u4E13%u533A%22%2C%22path%22%3A%22/lirisubPages/activity/special%22%2C%22success%22%3Atrue%2C%22argKey%22%3A%22id%22%2C%22argValue%22%3A%221687370505609617410%22%2C%22argParams%22%3A%22id%3D1687370505609617410%22%2C%22argName%22%3A%22%u65B0%u54C1%u63A2%u79D8%22%7D%7D%2C%7B%22top%22%3A%22-18.1%25%22%2C%22left%22%3A%2226.25%25%22%2C%22width%22%3A%2220%25%22%2C%22height%22%3A%22118.09%25%22%2C%22linkArg%22%3A%7B%22pathName%22%3A%22%u8D85%u5E02%u4E13%u533A%22%2C%22path%22%3A%22/lirisubPages/activity/special%22%2C%22success%22%3Atrue%2C%22argKey%22%3A%22id%22%2C%22argValue%22%3A%221922948918284115970%22%2C%22argParams%22%3A%22id%3D1922948918284115970%22%2C%22argName%22%3A%22%u4ECA%u65E5%u63A8%u8350%22%7D%7D%5D%7D%7D%2C%7B%22id%22%3A1661561492103%2C%22name%22%3A%22%u5546%u54C1%u5217%u8868%22%2C%22type%22%3A%22goodList%22%2C%22arg%22%3A%7B%22static%22%3Afalse%2C%22import%22%3Atrue%2C%22styleArg%22%3A%22fix%22%2C%22concat%22%3Atrue%2C%22autoLoad%22%3A%22N%22%2C%22dataNum%22%3A20%2C%22ids%22%3A%5B%223@132378%22%2C%223@133608%22%2C%223@131038%22%2C%223@130785%22%2C%223@129780%22%2C%223@7749%22%2C%223@131761%22%2C%223@131134%22%2C%223@131133%22%2C%223@131135%22%2C%223@133537%22%2C%223@131315%22%2C%223@130323%22%2C%223@130321%22%2C%223@131428%22%2C%223@131266%22%2C%223@130614%22%2C%223@130425%22%2C%223@130322%22%2C%223@115200%22%2C%223@128768%22%2C%223@128769%22%2C%223@126929%22%2C%223@124834%22%2C%223@122311%22%2C%223@85532%22%2C%223@113876%22%2C%223@116144%22%2C%223@112579%22%2C%223@112580%22%2C%223@112577%22%2C%223@112578%22%2C%223@110714%22%2C%223@111454%22%2C%223@111451%22%2C%223@110416%22%2C%223@106044%22%2C%223@106050%22%2C%223@21062%22%2C%223@85532%22%2C%223@16921%22%2C%223@58388%22%2C%223@30562%22%2C%223@23453%22%2C%223@1942%22%2C%223@43470%22%2C%223@92428%22%2C%223@20597%22%2C%223@101381%22%2C%223@75859%22%2C%223@103398%22%2C%223@103397%22%2C%223@16049%22%2C%223@13504%22%2C%223@16299%22%2C%223@16298%22%2C%223@16289%22%2C%223@131422%22%2C%223@131573%22%2C%223@14432%22%2C%223@133103%22%2C%223@131296%22%2C%223@131388%22%2C%223@130772%22%2C%223@129048%22%2C%223@130599%22%2C%223@130176%22%2C%223@129009%22%2C%223@125639%22%2C%223@122449%22%2C%223@121260%22%2C%223@122233%22%2C%223@122096%22%2C%223@117234%22%2C%223@111257%22%2C%223@112648%22%2C%223@111870%22%2C%223@112476%22%2C%223@111213%22%2C%223@109951%22%2C%223@110187%22%2C%223@108313%22%2C%223@79789%22%2C%223@89864%22%2C%223@89863%22%2C%223@2591%22%2C%223@50103%22%2C%223@46661%22%2C%223@1840%22%2C%223@14292%22%2C%223@101166%22%2C%223@828%22%2C%223@1376%22%2C%223@104443%22%2C%223@27192%22%2C%223@94757%22%2C%223@17134%22%2C%223@14543%22%2C%223@71492%22%2C%223@29979%22%2C%223@1532%22%2C%223@17668%22%2C%223@30545%22%2C%223@822%22%2C%223@94755%22%2C%223@76811%22%2C%223@63475%22%2C%223@87%22%2C%223@86270%22%2C%223@14444%22%2C%223@6265%22%2C%223@76161%22%2C%223@32163%22%2C%223@1259%22%2C%223@15442%22%2C%223@1239%22%2C%223@79475%22%2C%223@62332%22%2C%223@66883%22%2C%223@73964%22%2C%223@73615%22%2C%223@104953%22%2C%223@105680%22%2C%223@123900%22%2C%223@118541%22%2C%223@66672%22%2C%223@117855%22%2C%223@114737%22%2C%223@122502%22%2C%223@130623%22%2C%223@130959%22%2C%223@127165%22%2C%223@122152%22%2C%223@133344%22%2C%223@66880%22%2C%223@94008%22%2C%223@66917%22%2C%223@67048%22%5D%2C%22listStyle%22%3A%22double%22%2C%22layout%22%3A%22%22%2C%22show%22%3A%7B%22border%22%3A%22%22%2C%22radius%22%3Atrue%2C%22name%22%3Atrue%2C%22nameStyle%22%3A%22%22%2C%22price%22%3Atrue%2C%22origin%22%3Atrue%2C%22bug%22%3Atrue%2C%22bugStyle%22%3A%22custom%22%2C%22bugTxt%22%3A%22%u8D2D%u4E70%22%2C%22mark%22%3Afalse%2C%22markStyle%22%3A%22%22%2C%22desc%22%3Afalse%2C%22descTxt%22%3A%22%22%2C%22shopName%22%3Afalse%2C%22postType%22%3Afalse%2C%22reward%22%3Afalse%7D%7D%7D%2C%7B%22id%22%3A1671093902673%2C%22name%22%3A%22%u5E7F%u544A%u6A21%u5757%22%2C%22type%22%3A%22imageLink%22%2C%22arg%22%3A%7B%22styleArg%22%3A%22carousel%22%2C%22rowNum%22%3A%221%22%2C%22margin%22%3A%22no%22%2C%22isBackground%22%3Afalse%2C%22radius%22%3Atrue%2C%22space%22%3A0%2C%22lacuna%22%3A0%2C%22ids%22%3A%5B%7B%22img%22%3A%22https%3A//cdn.lirimall.com//lirigo/filetempImage/f75753a073880020bf553e53d394085_1692958094005.png%22%2C%22title%22%3A%22%22%2C%22linkArg%22%3A%7B%22pathName%22%3A%22%u8D85%u5E02%u5206%u7C7B%22%2C%22path%22%3A%22/lirisubPages/supermarket/class%22%2C%22success%22%3Atrue%2C%22argKey%22%3A%22id%22%2C%22argValue%22%3A%221030%22%2C%22argParams%22%3A%22id%3D1030%26pid%3D0%22%2C%22argName%22%3A%22%u65F6%u4EE4%u852C%u83DC%22%7D%7D%5D%2C%22taps%22%3A%5B%5D%7D%7D%5D",
        pageCover: null,
        isDefault: 1,
        sortNum: null,
        state: 0,
        createBy: "18218063785",
        createTime: "2024-08-13 09:18:52",
        updateBy: "15915963247",
        updateTime: "2025-10-07 18:13:27",
        createUserId: "1559395933481136130",
        updateUserId: "1559395933481136130",
        delFlag: "0",
        shopId: "1201",
      },
    });
  });
  // 获取模版页内容
  app.get("/mock/temp/info", function (req, res) {
    const query = getQuery(req.query);
    isDefault = parseInt(query.id);
    res.json({
      code: 200,
      result: {
        id: "1",
        templateName: "模版页面名称",
        templateJson: "",
      },
    });
  });
  // 上传资源
  app.post("/mock/resource/upload", function (req, res) {
    const query = getQuery(req.query);
    isDefault = parseInt(query.id);
    res.json({
      code: 200,
      message: "",
      url: "文件保存的地址",
    });
  });
  // 保存资源路径
  app.post("/mock/resource/save", function (req, res) {
    const query = getQuery(req.query);
    isDefault = parseInt(query.id);
    res.json({
      code: 200,
      result: [
        {
          fileName: "图片文件1",
          fileUrl: "",
          fileSize: "100kb",
          createTime: "2021-07-07",
        },
      ],
    });
  });
  // 获取资源
  app.get("/mock/resource/list", function (req, res) {
    const query = getQuery(req.query);
    const total = parseInt(query.pageSize) + 4;
    // eslint-disable-next-line no-unused-vars
    const max = parseInt(query.pageNo) > 1 ? 4 : parseInt(query.pageSize);
    // eslint-disable-next-line no-unused-vars
    const min = (parseInt(query.pageNo) - 1) * parseInt(query.pageSize);
    const imgSize = query.imgSize.split("*");
    let data = [];
    for (let i = 0; i < max; i++) {
      const obj = Mock.mock({
        id: min + i + 1, // Random.integer(),
        fileTyle: "png",
        fileName: "附件名称-" + Random.ctitle(1, 10),
        fileUrl: Random.image(
          `${imgSize[0]}x${imgSize[1]}`,
          "#deabab",
          "#FFF",
          "img"
        ),
        state: "1",
      });
      data.push(obj);
    }
    res.json({
      code: 200,
      result: {
        records: data,
        size: query.pageSize,
        current: query.pageNo,
        total: total,
      },
    });
  });
  // 获取店铺logo-getshopLogo
  app.post("/mock/shop/logo", function (req, res) {
    const query = getQuery(req.query);
    isDefault = parseInt(query.id);
    const logoImg = Mock.mock({
      logoImg: Random.image("140x160", "#000", "#FFF", "logo"),
    });
    res.json({
      code: 200,
      result: logoImg,
    });
  });
  // 获取链接
  app.get("/mock/link/list", function (req, res) {
    res.json({
      code: 200,
      result: [
        {
          id: "1",
          urlContent: "首页",
          urlPattern: "需要配置",
          childs: [
            {
              id: "1-1",
              isOpen: "0",
              urlContent: "门店首页",
              urlPattern: "需要配置",
            },
            {
              id: "1-2",
              isOpen: "0",
              urlContent: "超市首页首页",
              urlPattern: "需要配置",
            },
          ],
        },
        {
          id: "2",
          urlContent: "微页面",
          urlPattern: "需要配置",
          childs: [
            {
              id: "2-1",
              isOpen: "1",
              urlType: "支持门店选择、名称筛选｜商品类别",
              openUrl: "/mock/link/params",
              caseName: "id:id,pageName:页面名称",
              urlContent: "门店微页面",
              urlPattern: "需要配置",
            },
            {
              id: "2-2",
              isOpen: "1",
              urlType: "",
              openUrl: "/mock/link/params",
              caseName: "id:id,pageName:页面名称",
              urlContent: "超市微页面",
              urlPattern: "需要配置",
            },
          ],
        },
        {
          id: "3",
          isOpen: "2",
          urlContent: "自定义页面",
        },
      ],
    });
  });
  // 获取链接
  app.get("/mock/link/params", function (req, res) {
    res.json({
      code: 200,
      result: {
        records: [
          {
            pageName: "微页面1",
            id: "123",
          },
        ],
        size: 10,
        current: 1,
        total: 2,
      },
    });
  });
  app.get("/mock/goodGroup/list", goodGroup); //商品分组列表
  app.get("/mock/goodList/list", goodList); //商品列表
  app.get("/mock/toBargain/list", toBargain); //砍价
  app.get("/mock/toShopping/list", toShopping); //拼团
  app.get("/mock/shopCoupon/list", shopCoupon); //优惠券数据
  app.get("/mock/goodDiscount/list", goodDiscount); //限时抢购
  app.get("/mock/goodDiscount/good", goodDiscount2); //限时抢购商品
  app.get("/mock/goodSpecial/list", goodSpecial); //专区商品活动列表
  app.get("/mock/goodFine/list", goodFine); //优惠限购活动列表
  app.get("/mock/shopGroup/list", shopGroup); //商家列表
  app.get("/mock/goodIntegral/list", goodIntegral); //积分商品
  // ------动作接口--------
  // 领取卡劵 buyEcardCenter
  app.get("/mock/marketing/ecard/buyEcardCenter", function (req, res) {
    res.json({
      code: 200,
    });
  });
  // 获取商品详情 getProductDetail
  app.get("/mock/product/getProductDetail", function (req, res) {
    res.json({
      code: 200,
    });
  });
  // 加入购物车 updateMemberCartAddOrReduce
  app.post(
    "/mock/member/cart/updateMemberCartAddOrReduce",
    function (req, res) {
      res.json({
        code: 200,
      });
    }
  );
  // 获取购物车 getMemberCartList
  app.get("/mock/member/cart/getMemberCartList", function (req, res) {
    res.json({
      code: 200,
    });
  });
};
module.exports.mock = mock;
